
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Edit Product')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Edit Product')); ?></h1>
          </div>

          <div class="section-body">
            <a href="<?php echo e(route('admin.product.index')); ?>" class="btn btn-primary"><i class="fas fa-list"></i> <?php echo e(__('admin.Products')); ?></a>
            <div class="row mt-4">

                <div class="col-12">
                    <div class="card">
                      <div class="card-body">
                        <h3 class="h3 mb-3 text-gray-800"><?php echo e(__('admin.Language')); ?></h3>
                        <hr>
                        <div class="lang_list_top">
                            <ul class="lang_list">
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('admin.product.edit',['product' => $product->id, 'lang_code' => $language->lang_code])); ?>"><i class="fas fa-edit"></i> <?php echo e($language->lang_name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>

                        <div class="alert alert-danger" role="alert">
                            <?php
                                $current_language = App\Models\Language::where('lang_code', request()->get('lang_code'))->first();
                            ?>
                            <p><?php echo e(__('admin.Your editing mode')); ?> : <b><?php echo e($current_language->lang_name); ?></b></p>
                        </div>
                      </div>
                    </div>
                </div>
                <div class="col-12">
                  <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.product.update', $product->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="row">

                                <?php if(session()->get('admin_lang') == request()->get('lang_code')): ?>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Existing thumbnail')); ?></label>
                                    <div>
                                        <img class="w_200" src="<?php echo e(custom_asset($product->thumbnail_image)); ?>" alt="">
                                    </div>
                                </div>

                                <input type="hidden" name="product_type" value="<?php echo e($product_type); ?>">
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Thumbnail Image')); ?></label>
                                    <input type="file" class="form-control-file"  name="thumb_image">
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Existing icon')); ?></label>
                                    <div>
                                        <img class="product_icom_image" src="<?php echo e(custom_asset($product->product_icon)); ?>" alt="">
                                    </div>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Product icon')); ?></label>
                                    <input type="file" class="form-control-file"  name="product_icon">
                                </div>

                                <?php if($product->upload_file_link): ?>

                                <div class="form-group col-12 upload_file_box">
                                    <div class="wsus__comment_single_input">
                                        <label><?php echo e(__('admin.Third-Party Link')); ?> <span class="text-danger">* </span></label>
                                        <input type="url" name="upload_file_link" class="form-control" value="<?php echo e(html_decode($product->upload_file_link)); ?>">
                                    </div>
                                </div>
                                <?php else: ?>

                                    <div class="form-group col-12 upload_file_box">
                                        <label><?php echo e(__('admin.Upload file')); ?> <span class="text-danger">(<?php echo e(__('admin.only zip file allowed')); ?>)</span></label>
                                        <input type="file" class="form-control" name="upload_file" accept=".zip">
                                        <?php if($product->download_file): ?>
                                            <label for=""><a class="text-dark text-bold" href="<?php echo e(route('admin.personal-download-script', $product->id)); ?>"><?php echo e(__('admin.Download existing file')); ?></a></label>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Category')); ?> <span class="text-danger">*</span></label>
                                    <select name="category" class="form-control select2" id="category">
                                        <option value=""><?php echo e(__('admin.Select Category')); ?></option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e($product->category_id == $category->id ? 'selected' : ''); ?> value="<?php echo e($category->id); ?>"><?php echo e($category->catlangadmin->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Author')); ?> <span class="text-danger">*</span></label>
                                    <select name="author" class="form-control select2" id="author">
                                        <option value=""><?php echo e(__('admin.Select Author')); ?></option>
                                        <?php $__currentLoopData = $authors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $author): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e($product->author_id == $author->id ? 'selected' : ''); ?> value="<?php echo e($author->id); ?>"><?php echo e(html_decode($author->name)); ?> - <?php echo e($author->user_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <?php endif; ?>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Name')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" id="name" class="form-control"  name="name" value="<?php echo e(html_decode($product_language->name)); ?>">
                                    <input type="hidden" name="lang_code" value="<?php echo e(request()->get('lang_code')); ?>">
                                </div>



                                <?php if(session()->get('admin_lang') == request()->get('lang_code')): ?>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Preview link')); ?> <span class="text-danger">*</span></label>
                                   <input type="text" class="form-control" name="preview_link" value="<?php echo e(html_decode($product->preview_link)); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Regular price')); ?> <span class="text-danger">* (<?php echo e(__('USD Price')); ?>)</span></label>
                                   <input type="text" class="form-control" name="regular_price" value="<?php echo e(html_decode($product->regular_price)); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Extend price')); ?> <span class="text-danger">* (<?php echo e(__('USD Price')); ?>)</span></label>
                                   <input type="text" class="form-control" name="extend_price" value="<?php echo e(html_decode($product->extend_price)); ?>">
                                </div>

                                <?php endif; ?>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Description')); ?> <span class="text-danger">*</span></label>
                                    <textarea name="description" id="" cols="30" rows="10" class="summernote"><?php echo e(html_decode($product_language->description)); ?></textarea>
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Tags')); ?> <span class="text-danger">*</span> (<?php echo e(__('admin.Press the comma for new tag')); ?>)</label><br>
                                   <input type="text" class="form-control" data-role="tagsinput" name="tags" value="<?php echo e(html_decode($product_language->tags)); ?>">
                                </div>
                                <?php if(session()->get('admin_lang') == request()->get('lang_code')): ?>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Status')); ?> <span class="text-danger">*</span></label>
                                    <select name="status" class="form-control">
                                        <option <?php echo e($product->status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Active')); ?></option>
                                        <option <?php echo e($product->status == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.Inactive')); ?></option>
                                    </select>
                                </div>
                                <?php endif; ?>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.SEO Title')); ?></label>
                                   <input type="text" class="form-control" name="seo_title" value="<?php echo e(html_decode($product_language->seo_title)); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.SEO Description')); ?></label>
                                    <textarea name="seo_description" id="" cols="30" rows="10" class="form-control text-area-5"><?php echo e(html_decode($product_language->seo_description)); ?></textarea>
                                </div>
                                <?php if(session()->get('admin_lang') == request()->get('lang_code')): ?>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Highlight')); ?></label>
                                    <div>
                                        <input <?php echo e($product->popular_item == 1 ? 'checked' : ''); ?> type="checkbox"name="popular_item" id="popular_item"> <label for="popular_item" class="mr-3" ><?php echo e(__('admin.Popular')); ?></label>

                                        <input <?php echo e($product->trending_item == 1 ? 'checked' : ''); ?>  type="checkbox" name="trending_item" id="trending_item"> <label for="trending_item" class="mr-3" ><?php echo e(__('admin.Trending')); ?></label>

                                        <input <?php echo e($product->featured_item == 1 ? 'checked' : ''); ?> type="checkbox" name="featured_item" id="featured_item"> <label for="featured_item" class="mr-3" ><?php echo e(__('admin.Featured')); ?></label>

                                        <input <?php echo e($product->high_resolution == 1 ? 'checked' : ''); ?> type="checkbox" name="high_resolution" id="high_resolution"> <label for="high_resolution" class="mr-3" ><?php echo e(__('admin.High Resolution')); ?></label>

                                        <input <?php echo e($product->cross_browser == 1 ? 'checked' : ''); ?> type="checkbox" name="cross_browser" id="cross_browser"> <label for="cross_browser" class="mr-3" ><?php echo e(__('admin.Cross Browser')); ?></label>

                                        <input <?php echo e($product->documentation == 1 ? 'checked' : ''); ?> type="checkbox" name="documentation" id="documentation"> <label for="documentation" class="mr-3" ><?php echo e(__('admin.Documentation')); ?></label>

                                        <input <?php echo e($product->layout == 1 ? 'checked' : ''); ?> type="checkbox" name="layout" id="layout"> <label for="layout" class="mr-3" ><?php echo e(__('admin.Responsive')); ?></label>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>

<script>
    (function($) {
        "use strict";
        var specification = true;
        $(document).ready(function () {
            $("#name").on("focusout",function(e){
                $("#slug").val(convertToSlug($(this).val()));
            })

            $("#download_file_type").on("change", function(){
                let currentVal = $(this).val();
                if(currentVal == 'direct_upload'){
                    $(".upload_file_box").removeClass('d-none')
                    $(".download_link_box").addClass('d-none')
                }else{
                    $(".upload_file_box").addClass('d-none')
                    $(".download_link_box").removeClass('d-none')
                }


            })




        });
    })(jQuery);

    function convertToSlug(Text){
            return Text
                .toLowerCase()
                .replace(/[^\w ]+/g,'')
                .replace(/ +/g,'-');
    }


</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Projects\New folder\alasmart_cc\main_files\main_files\resources\views/admin/edit_product.blade.php ENDPATH**/ ?>