

<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('user.Create product')); ?></title>
    <meta name="description" content="<?php echo e(__('user.Create product')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontend-content'); ?>
    <!--=============================
        UPLOAD PRODUCT INFO START
    ==============================-->
    <section class="upload_product_info pt_190 pb_100 xs_pb_70">
        <div class="container wow fadeInUp" data-wow-duration="1s">
            <h3><?php echo e(__('user.Upload your Product')); ?> </h3>
            <form class="upload_product_form" action="<?php echo e(route('product-store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="row">
                    
                    


                     <div class="col-xl-6 col-md-6 mb-3">
                        <div class="upload_form_input">
                            <label><?php echo e(__('user.Thumbnail Image')); ?>*</label>
                            <div class="upload_box">
                                <div class="img">
                                    <img src="<?php echo e(asset('frontend/images/upload_1.png')); ?>" alt="upload icon" class="img-fluid w-100">
                                </div>
                                <label for="upload_11"><?php echo e(__('user.Please')); ?> <span><?php echo e(__('user.Choose File')); ?></span> <?php echo e(__('user.to upload')); ?> </label>
                                <input id="upload_11" name="thumb_image" type="file" hidden>
                            </div>
                        </div>
                    </div>


                    <div class="col-xl-12 col-md-12">
                        <!-- Toggle Option -->
                        <div class="col-xl-4 col-md-12 mb-3 mt-4">
                            <div class="row align-items-center mt-3">
                                <!-- File Upload Option -->
                                <div class="col-md-6 mb-2">
                                    <div class="form-check">
                                        <input 
                                            type="radio" 
                                            id="upload_file_option" 
                                            name="upload_method" 
                                            value="file" 
                                            class="form-check-input" 
                                            checked
                                        >
                                        <label for="upload_file_option" class="form-check-label">Upload File</label>
                                    </div>
                                </div>
                        
                                <!-- Third-Party Link Option -->
                                <div class="col-md-6 col-sm-12 mb-2">
                                    <div class="form-check">
                                        <input 
                                            type="radio" 
                                            id="upload_link_option" 
                                            name="upload_method" 
                                            value="link" 
                                            class="form-check-input"
                                        >
                                        <label for="upload_link_option" class="form-check-label">Use Third-Party Link</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- File Upload Section -->
                        <div class="col-xl-12 col-md-12 upload_file_section">
                            <div class="row">
                                <div class="col-xl-6 col-md-6 upload_form_input">
                                    <label>Upload File* <span> (<b>Only ZIP file allowed</b>)</span></label>
                                    <div class="upload_box">
                                        <div class="img">
                                            <img src="<?php echo e(asset('frontend/images/upload_2.png')); ?>" alt="upload icon" class="img-fluid w-100">
                                        </div>
                                        <label for="upload_1"><?php echo e(__('user.Please')); ?> <span><?php echo e(__('user.Choose File')); ?></span> <?php echo e(__('user.to upload')); ?> </label>
                                        <input id="upload_1" name="upload_file" accept=".zip" type="file">
                                    </div>
                                </div>
                            </div>
                        </div>
                    
                        <!-- Third-Party Link Section -->
                        <div class="col-xl-12 col-md-6 upload_link_section upload_file_link">
                            <div class="wsus__comment_single_input">
                                <fieldset>
                                    <legend>Third-Party Link*</legend>
                                    <input type="url" name="upload_file_link" placeholder="Enter Third-Party Link">
                                </fieldset>
                            </div>
                        </div>
                    </div>
                    
                    
                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <fieldset>
                                <legend><?php echo e(__('user.Product icon')); ?>*</legend>
                                <input type="file" name="product_icon">
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <fieldset>
                                <legend><?php echo e(__('user.Category')); ?>*</legend>
                                <select class="select2" name="category">
                                    <option value=""><?php echo e(__('user.Select Category')); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->catlangfrontend->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <fieldset>
                                <legend><?php echo e(__('user.Product Name')); ?>*</legend>
                                <input type="text" id="name" name="name" value="<?php echo e(old('name')); ?>">
                                <input type="hidden" name="product_type" value="<?php echo e($product_type); ?>">
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <fieldset>
                                <legend><?php echo e(__('user.Slug')); ?>*</legend>
                                <input type="text" id="slug" name="slug" value="<?php echo e(old('slug')); ?>">
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <fieldset>
                                <legend><?php echo e(__('user.Preview link')); ?>*</legend>
                                <input type="text" name="preview_link" value="<?php echo e(old('preview_link')); ?>">
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="wsus__comment_single_input">
                            <fieldset>
                                <legend><?php echo e(__('user.Regular price')); ?>* (<?php echo e(__('USD Price')); ?>)</legend>
                                <input type="text" name="regular_price" value="<?php echo e(old('regular_price')); ?>">
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="wsus__comment_single_input">
                            <fieldset>
                                <legend><?php echo e(__('user.Extend price')); ?>* (<?php echo e(__('USD Price')); ?>)</legend>
                                <input type="text" name="extend_price" value="<?php echo e(old('extend_price')); ?>">
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <legend><?php echo e(__('user.Description')); ?>*</legend>
                            <textarea id="editor" name="description" rows="8"><?php echo e(old('description')); ?></textarea>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <fieldset>
                                <legend><?php echo e(__('user.Tags')); ?>* <?php echo e(__('user.Press the comma for new tag')); ?></legend>
                                <input type="text" data-role="tagsinput" name="tags" value="<?php echo e(old('tags')); ?>">
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <fieldset>
                                <legend><?php echo e(__('user.SEO title')); ?>*</legend>
                                <input type="text" name="seo_title" value="<?php echo e(old('seo_title')); ?>">
                            </fieldset>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <fieldset>
                                <legend><?php echo e(__('user.SEO description')); ?>*</legend>
                                <textarea rows="4" name="seo_description"><?php echo e(old('seo_description')); ?></textarea>
                            </fieldset>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <div class="row">
                                <div class="col-12">
                                    <h4><?php echo e(__('user.Others feature')); ?></h4>
                                </div>
                                <div class="col-12">
                                    <input type="checkbox" name="high_resolution" id="high_resolution"> 
                                    <label for="high_resolution" class="mr-3" ><?php echo e(__('user.High Resolution')); ?></label>
                                </div>
                                <div class="col-12">
                                    <input type="checkbox" name="cross_browser" id="cross_browser"> 
                                    <label for="cross_browser" class="mr-3" ><?php echo e(__('user.Cross Browser')); ?></label>
                                </div>
                                <div class="col-12">
                                    <input type="checkbox" name="documentation" id="documentation"> 
                                    <label for="documentation" class="mr-3" ><?php echo e(__('user.Documentation')); ?></label>
                                </div>
                                <div class="col-12">
                                    <input type="checkbox" name="layout" id="layout"> <label for="layout" class="mr-3" ><?php echo e(__('user.Responsive')); ?></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="wsus__comment_single_input">
                            <button class="common_btn upload" type="submit"><?php echo e(__('user.upload Product')); ?></button>
                        </div>
                    </div>
                </div>
            </form>

        </div>
    </section>
    <!--=============================
        UPLOAD PRODUCT INFO END
    ==============================-->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('frontend_js'); ?>
    
<script>
    (function($) {
        "use strict";
        var specification = true;
        $(document).ready(function () {
            $("#name").on("focusout",function(e){
                $("#slug").val(convertToSlug($(this).val()));
            })

            $("#download_file_type").on("change", function(){
                let currentVal = $(this).val();
                if(currentVal == 'direct_upload'){
                    $(".upload_file_box").removeClass('d-none')
                    $(".download_link_box").addClass('d-none')
                }else{
                    $(".upload_file_box").addClass('d-none')
                    $(".download_link_box").removeClass('d-none')
                }
            })
        });
    })(jQuery);

    function convertToSlug(Text){
            return Text
                .toLowerCase()
                .replace(/[^\w ]+/g,'')
                .replace(/ +/g,'-');
    }




    document.addEventListener('DOMContentLoaded', function () {
        const fileOption = document.getElementById('upload_file_option');
        const linkOption = document.getElementById('upload_link_option');
        const fileSection = document.querySelector('.upload_file_section');
        const linkSection = document.querySelector('.upload_link_section');

        fileOption.addEventListener('change', function () {
            if (fileOption.checked) {
                fileSection.style.display = 'block';
                linkSection.style.display = 'none';
            }
        });

        linkOption.addEventListener('change', function () {
            if (linkOption.checked) {
                fileSection.style.display = 'none';
                linkSection.style.display = 'block';
            }
        });
    });

    document.addEventListener("DOMContentLoaded", function () {
        const uploadFileOption = document.getElementById("upload_file_option");
        const uploadLinkOption = document.getElementById("upload_link_option");
        const uploadFileSection = document.querySelector(".upload_file_section");
        const uploadLinkSection = document.querySelector(".upload_link_section");

        function toggleSections() {
            if (uploadFileOption.checked) {
                uploadFileSection.style.display = "block";
                uploadLinkSection.style.display = "none";
            } else if (uploadLinkOption.checked) {
                uploadFileSection.style.display = "none";
                uploadLinkSection.style.display = "block";
            }
        }

        // Attach event listeners
        uploadFileOption.addEventListener("change", toggleSections);
        uploadLinkOption.addEventListener("change", toggleSections);

        // Initialize on page load
        toggleSections();
    });




</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($active_theme, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Projects\New folder\alasmart_cc\main_files\main_files\resources\views/user/create_product.blade.php ENDPATH**/ ?>