
<?php $__env->startSection('title'); ?>
<title><?php echo e($title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e($title); ?></h1>
          </div>

          <div class="section-body">
            <div class="row mt-4">
                <?php if($orders->count() > 0): ?>
                <div class="col">
                    <div class="card">
                      <div class="card-body">
                        <div class="table-responsive table-invoice">
                          <table class="table table-striped" id="dataTable">
                              <thead>
                                  <tr>
                                      <th width="5%"><?php echo e(__('admin.SN')); ?></th>
                                      <th width="10%"><?php echo e(__('admin.Customer')); ?></th>
                                      <th width="10%"><?php echo e(__('admin.Order Id')); ?></th>
                                      <th width="10%"><?php echo e(__('admin.Date')); ?></th>
                                      <th width="10%"><?php echo e(__('admin.Quantity')); ?></th>
                                      <th width="10%"><?php echo e(__('admin.Amount')); ?></th>
                                      <th width="10%"><?php echo e(__('admin.Order Status')); ?></th>
                                      <th width="10%"><?php echo e(__('admin.Payment')); ?></th>
                                      <th width="15%"><?php echo e(__('admin.Action')); ?></th>
                                    </tr>
                              </thead>
                              <tbody>
                                  <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <tr>
                                          <td><?php echo e(++$index); ?></td>
                                          <td><a href="<?php echo e(route('admin.customer-show', $order->user->id)); ?>"><?php echo e($order->user->name); ?></a></td>
                                          <td><?php echo e($order->order_id); ?></td>
                                          <td><?php echo e(Carbon\Carbon::parse($order->created_at)->format('d F, Y')); ?></td>
                                          <td><?php echo e($order->cart_qty); ?></td>
                                          <td><?php echo e($setting->currency_icon); ?><?php echo e(round($order->total_amount)); ?></td>
                                          <td>
                                              <?php if($order->order_status == 1): ?>
                                              <span class="badge badge-success"><?php echo e(__('admin.Complete')); ?> </span>
                                              <?php elseif($order->order_status == 0): ?>
                                              <span class="badge badge-danger"><?php echo e(__('admin.Pending')); ?> </span>
                                              <?php endif; ?>
                                          </td>
                                          <td>
                                              <?php if($order->payment_status == 'success'): ?>
                                              <span class="badge badge-success"><?php echo e(__('admin.success')); ?> </span>
                                              <?php else: ?>
                                              <span class="badge badge-danger"><?php echo e(__('admin.Pending')); ?></span>
                                              <?php endif; ?>
                                          </td>
  
                                          <td>
  
                                          <a href="<?php echo e(route('admin.order-show',$order->id)); ?>" class="btn btn-primary btn-sm"><i class="fa fa-eye" aria-hidden="true"></i></a>
  
                                          <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="btn btn-danger btn-sm" onclick="deleteData(<?php echo e($order->id); ?>)"><i class="fa fa-trash" aria-hidden="true"></i></a>
  
                                          <a href="javascript:;" data-toggle="modal" data-target="#orderModalId-<?php echo e($order->id); ?>" class="btn btn-warning btn-sm"><i class="fas fa-truck" aria-hidden="true"></i></a>
                                          </td>
                                      </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                <?php else: ?>
                    <div class="col-12 text-center">
                        <h4 class="text-danger"><?php echo e(__('admin.Order not found!')); ?></h4>
                    </div>
                <?php endif; ?>

                <div class="col-12">
                    <?php echo e($orders->links()); ?>

                </div>
            </div>
          </div>
        </section>
      </div>

<!-- Modal -->
<?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="orderModalId-<?php echo e($order->id); ?>" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
                <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('admin.Order Status')); ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                    </div>
            <div class="modal-body">
                <div class="container-fluid">
                    <form action="<?php echo e(route('admin.update-order-status',$order->id)); ?>" method="POST">
                      <?php echo method_field('PUT'); ?>
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for=""><?php echo e(__('admin.Payment')); ?></label>
                            <select name="payment_status" id="" class="form-control">
                                <option <?php echo e($order->payment_status == 'pending' ? 'selected' : ''); ?> value="pending"><?php echo e(__('admin.Pending')); ?></option>
                                <option <?php echo e($order->payment_status == 'success' ? 'selected' : ''); ?> value="success"><?php echo e(__('admin.Success')); ?></option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for=""><?php echo e(__('admin.Order')); ?></label>
                            <select name="order_status" id="" class="form-control">
                              <option <?php echo e($order->order_status == 0 ? 'selected' : ''); ?> value="0"><?php echo e(__('admin.Pending')); ?></option>
                              <option <?php echo e($order->order_status == 1 ? 'selected' : ''); ?> value="1"><?php echo e(__('admin.Complete')); ?></option>
                            </select>
                        </div>


                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('admin.Close')); ?></button>
                <button type="submit" class="btn btn-primary"><?php echo e(__('admin.Update Status')); ?></button>
            </div>
          </form>
        </div>
    </div>
</div>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


<script>
  "use strict";
    function deleteData(id){
        $("#deleteForm").attr("action",'<?php echo e(url("admin/delete-order/")); ?>'+"/"+id)
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Projects\New folder\alasmart_cc\main_files\main_files\resources\views/admin/order.blade.php ENDPATH**/ ?>