

<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('user.Buying product')); ?></title>
    <meta name="description" content="<?php echo e(__('user.Buying product')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontend-content'); ?>
    <!--=============================
        PROFILE DOWNLOAD START
    ==============================-->
    <section class="wsus__profile pt_130 xs_pt_100 pb_120 xs_pb_80">

        <?php echo $__env->make('user.inc.profile_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="row">
                <div class="col-xl-8 col-lg-8">
                    <div class="wsus__profile_download">
                        <h2><?php echo e(__('user.Buying Items')); ?></h2>

                        <?php $__currentLoopData = $order_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->order->order_status == 1): ?>
                                <div class="wsus__download_item">
                                    <div class="wsus__download_item_left">
                                        <div class="img">
                                            <img src="<?php echo e(custom_asset($item->product->thumbnail_image)); ?>" alt="download" class="img-fluid w-100">
                                        </div>
                                        <div class="text">
                                            <a href="<?php echo e(route('product-detail', $item->product->slug)); ?>"><?php echo e(html_decode($item->product->productlangfrontend->name)); ?></a>
                                            <p><?php echo e(__('user.Item by')); ?> <?php echo e(html_decode($item->author->name)); ?></p>
                                            <?php if($item->variant_id!=null): ?>
                                            <p><?php echo e(html_decode($item->variant->variant_name)); ?></p>
                                            <?php endif; ?>
                                            <?php if($item->price_type!=null): ?>
                                            <p><?php echo e(ucfirst($item->price_type)); ?></p>
                                            <?php endif; ?>
                                            <h4>
                                                <?php if(session()->get('currency_position') == 'right'): ?>
                                                    <?php echo e(html_decode($item->price * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                                <?php else: ?>
                                                    <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($item->price * session()->get('currency_rate'))); ?>

                                                <?php endif; ?>
                                            </h4>
                                        </div>
                                    </div>
                                    <div class="wsus__download_item_right">
                                        <?php if($item->product_type=='script'): ?>
                                        <a class="common_btn" href="<?php echo e(route('download-script', $item->product->id)); ?>" target="_blank" ><?php echo e(__('user.Download File')); ?></a>
                                        <?php else: ?>
                                            <?php if($item->variant): ?>
                                                <a class="common_btn" href="<?php echo e(route('download-variant-item', $item->variant->id)); ?>" target="_blank"><?php echo e(__('user.Download File')); ?></a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <?php
                                            $review=App\Models\Review::where(['product_id' => $item->product->id, 'status' => 1])->get()->average('rating');
                                        ?>
                                        <p data-bs-toggle="modal" data-bs-target="#review<?php echo e($item->product->id); ?>">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= $review): ?>
                                                <i class="fas fa-star text-warning"></i>
                                                <?php else: ?>
                                                <i class="fas fa-star"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <div class="wsus__pagination mt_25">
                            <div class="row">
                                <?php if($order_items->hasPages()): ?>
                                    <?php echo e($order_items->links('custom_pagination')); ?>

                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- rating modal end -->
                        <div class="wsus__rating_moadl_area">
                            <?php $__currentLoopData = $order_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="modal fade" id="review<?php echo e($item->product->id); ?>" tabindex="-1"
                            aria-labelledby="exampleModalLabel2" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <div class="text">
                                                <div class="modal-header">
                                                    <h1 class="modal-title fs-5" id="exampleModalLabel2"><?php echo e(__('user.Review this Item')); ?>

                                                    </h1>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <p><?php echo e(__('user.Your Rating')); ?></p>
                                                    <p>
                                                        <i class="far fa-star text-dark s1"></i>
                                                        <i class="far fa-star text-dark s2"></i>
                                                        <i class="far fa-star text-dark s3"></i>
                                                        <i class="far fa-star text-dark s4"></i>
                                                        <i class="far fa-star text-dark s5"></i>
                                                    </p>
                                                    <form id="reviewForm" action="<?php echo e(route('user-product-review')); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <label><?php echo e(__('user.Comment')); ?>*</label>
                                                        <input type="hidden" class="star" name="rating" value="">
                                                        <input type="hidden" id="product_id" name="product_id" value="<?php echo e($item->product->id); ?>">
                                                        <input type="hidden" id="order_id" name="order_id" value="<?php echo e($item->order->id); ?>">
                                                        <?php if($item->product->product_type!='script' && $item->variant): ?>
                                                        <input type="hidden" id="variant_id" name="variant_id" value="<?php echo e($item->variant->id); ?>">
                                                        <?php endif; ?>
                                                        <input type="hidden" id="author_id" name="author_id" value="<?php echo e($item->author->id); ?>">

                                                        <textarea rows="7" name="review"
                                                            placeholder="<?php echo e(__('user.Type your message here')); ?>"></textarea>
                                                        <button type="submit" class="common_btn"><?php echo e(__('user.Save Review')); ?></button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="img">
                                                <img src="<?php echo e(asset('frontend/images/rating_modal_img.jpg')); ?>" alt="rating" class="img-fluid w-100">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <!-- rating modal end -->
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4">
                    <?php echo $__env->make('user.inc.user_information', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        PROFILE DOWNLOAD END
    ==============================-->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('frontend_js'); ?>
<script>
    "use strict";
    $(document).ready(function(){
        $(document).ready(function(){
        $('.s1').on('click', function(){
            $('.s2, .s3, .s4, .s5').removeClass('fas fa-star text-warning');
            $('.s2, .s3, .s4, .s5').addClass('far fa-star text-dark');
            $('.s1').removeClass('far fa-star text-dark');
            $('.s1').addClass('fas fa-star text-warning');
            $('.star').val('');
            $('.star').val(1);
        });
        $('.s2').on('click', function(){
            $('.s3, .s4, .s5').removeClass('fas fa-star text-warning');
            $('.s3, .s4, .s5').addClass('far fa-star text-dark');
            $('.s1, .s2').removeClass('far fa-star text-dark');
            $('.s1, .s2').addClass('fas fa-star text-warning');
            $('.star').val('');
            $('.star').val(2);
        });
        $('.s3').on('click', function(){
            $('.s4, .s5').removeClass('fas fa-star text-warning');
            $('.s4, .s5').addClass('far fa-star text-dark');
            $('.s1, .s2, .s3').removeClass('far fa-star text-dark');
            $('.s1, .s2, .s3').addClass('fas fa-star text-warning');
            $('.star').val('');
            $('.star').val(3);
        });
        $('.s4').on('click', function(){
            $('.s5').removeClass('fas fa-star text-warning');
            $('.s5').addClass('far fa-star text-dark');
            $('.s1, .s2, .s3, .s4').removeClass('far fa-star text-dark');
            $('.s1, .s2, .s3, .s4').addClass('fas fa-star text-warning');
            $('.star').val('');
            $('.star').val(4);
        });
        $('.s5').on('click', function(){
            $('.s1, .s2, .s3, .s4, .s5').removeClass('far fa-star text-dark');
            $('.s1, .s2, .s3, .s4, .s5').addClass('fas fa-star text-warning');
            $('.star').val('');
            $('.star').val(5);
        });
    })
    })
</script>


<script>

    (function($) {
        "use strict";
        $(document).ready(function () {
            $("#contactWithAuthor").on("submit", function(e){
                e.preventDefault();

                var isDemo = "<?php echo e(env('APP_MODE')); ?>"
                if(isDemo == 'DEMO'){
                    toastr.error('This Is Demo Version. You Can Not Change Anything');
                    return;
                }
                 $('#submitBtn').addClass('d-none');
                 $('#showSpain').removeClass('d-none');
                $.ajax({
                    url: "<?php echo e(route('contact-with-author')); ?>",
                    type:"post",
                    data:$('#contactWithAuthor').serialize(),
                    success:function(response){
                        if(response.status == 1){
                            toastr.success(response.message)
                            $("#contactWithAuthor").trigger("reset");
                            $('#submitBtn').removeClass('d-none');
                            $('#showSpain').addClass('d-none');
                        }
                    },
                    error:function(response){
                        if(response.status == 403){
                            toastr.error(response.responseJSON.message);
                            $('#submitBtn').removeClass('d-none');
                            $('#showSpain').addClass('d-none');
                        }else{
                            if(response.responseJSON.errors.email)toastr.error(response.responseJSON.errors.email[0])
                            if(response.responseJSON.errors.message)toastr.error(response.responseJSON.errors.message[0])
                            $('#submitBtn').removeClass('d-none');
                            $('#showSpain').addClass('d-none');
                        }
                    }
                });
            });
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($active_theme, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Projects\New folder\alasmart_cc\main_files\main_files\resources\views/user/download.blade.php ENDPATH**/ ?>