

<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('user.Check Out')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontend-content'); ?>
    <!--=============================
        BREADCRUMB START
    ==============================-->
    <section class="wsus__breadcrumb" style="background: url(<?php echo e(custom_asset('frontend/images/breadcrumb_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="wsus__breadcrumb_text">
                        <h1><?php echo e(__('user.Check Out')); ?></h1>
                        <ul class="d-flex flex-wrap">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.Home')); ?></a></li>
                            <li><a href="javascript:;"><?php echo e(__('user.Check Out')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BREADCRUMB END
    ==============================-->


    <!--=============================
        CHECKOUT START
    ==============================-->
    <section class="wsus__checkout pt_120 xs_pt_80 pb_120 xs_pb_80">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 col-lg-7">
                    <div class="wsus__checkout_text">
                        <h3><?php echo e(__('user.Select your payment method')); ?></h3>
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
                            <?php if($stripe->status == 1): ?>
                            <li class="nav-item">
                                <button class="nav-link active" data-bs-toggle="modal" data-bs-target="#stripeModal">
                                    <img src="<?php echo e(custom_asset($stripe->image)); ?>" alt="stripe" class="img-fluis w-100">
                                </button>
                            </li>
                            <?php endif; ?>
                            <?php if($paypal->status == 1): ?>
                            <li class="nav-item">
                                <form action="<?php echo e(route('pay-with-paypal')); ?>" method="GET" id="paypalForm">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="total_amount" value="<?php echo e($cartTotal); ?>">
                                    <input type="hidden" name="cart_qty" value="<?php echo e($cartQty); ?>">
                                </form>
                                <button class="nav-link" id="paypal" data-bs-toggle="pill">
                                    <img src="<?php echo e(custom_asset($paypal->image)); ?>" alt="paypal" class="img-fluis w-100">
                                </button>
                            </li>
                            <?php endif; ?>
                            <?php if($mollie->mollie_status == 1): ?>
                            <li class="nav-item">
                                <button class="nav-link" id="mollie" data-bs-toggle="pill">
                                    <img src="<?php echo e(custom_asset($mollie->mollie_image)); ?>" alt="paypal" class="img-fluis w-100">
                                </button>
                                <form action="<?php echo e(route('pay-with-mollie')); ?>" method="GET" id="mollieForm">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="total_amount" value="<?php echo e($cartTotal); ?>">
                                    <input type="hidden" name="cart_qty" value="<?php echo e($cartQty); ?>">
                                </form>
                            </li>
                            <?php endif; ?>
                            <?php if($instamojo->status == 1): ?>
                            <li class="nav-item">
                                <button class="nav-link" id="instamojo" data-bs-toggle="pill">
                                    <img src="<?php echo e(custom_asset($instamojo->image)); ?>" alt="Degmark" class="img-fluis w-100">
                                </button>
                                <form action="<?php echo e(route('pay-with-instamojo')); ?>" method="GET" id="instamojoForm">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="total_amount" value="<?php echo e($cartTotal); ?>">
                                    <input type="hidden" name="cart_qty" value="<?php echo e($cartQty); ?>">
                                </form>
                            </li>
                            <?php endif; ?>
                            <?php if($paystack->paystack_status == 1): ?>
                            <li class="nav-item">
                                <button class="nav-link" onclick="payWithPaystack()" data-bs-toggle="pill">
                                    <img src="<?php echo e(custom_asset($paystack->paystack_image)); ?>" alt="Degmark" class="img-fluis w-100">
                                </button>
                                <input type="hidden" name="total_amount" id="total_amount" value="<?php echo e($cartTotal); ?>">
                                <input type="hidden" name="cart_qty" id="cart_qty" value="<?php echo e($cartQty); ?>">
                            </li>
                            <?php endif; ?>
                            <?php if($razorpay->status == 1): ?>
                            <li class="nav-item">
                                <button class="nav-link" id="rajorpay" data-bs-toggle="pill">
                                    <img src="<?php echo e(custom_asset($razorpay->image)); ?>" alt="Degmark" class="img-fluis w-100">
                                </button>
                                <form action="<?php echo e(route('pay-with-razorpay')); ?>" class="d-none" method="POST" id="rajorpayForm">
                                <?php echo csrf_field(); ?>
                                <?php
                                    $payable_amount = intval($cartTotal) * $razorpay->currency->currency_rate;
                                    $payable_amount = round($payable_amount, 2);
                                ?>
                                <script src="https://checkout.razorpay.com/v1/checkout.js"
                                        data-key="<?php echo e($razorpay->key); ?>"
                                        data-currency="<?php echo e($razorpay->currency->currency_code); ?>"
                                        data-amount= "<?php echo e($payable_amount * 100); ?>"
                                        data-buttontext="<?php echo e(__('user.Pay')); ?> <?php echo e($payable_amount); ?> <?php echo e($razorpay->currency->currency_code); ?>"
                                        data-name="<?php echo e($razorpay->name); ?>"
                                        data-description="<?php echo e($razorpay->description); ?>"
                                        data-image="<?php echo e(custom_asset($razorpay->image)); ?>"
                                        data-prefill.name=""
                                        data-prefill.email=""
                                        data-theme.color="<?php echo e($razorpay->color); ?>">
                                </script>
                                    <input type="hidden" name="total_amount" value="<?php echo e($cartTotal); ?>">
                                    <input type="hidden" name="cart_qty" value="<?php echo e($cartQty); ?>">
                                </form>
                            </li>
                            <?php endif; ?>
                            <?php if($flutterwave->status == 1): ?>
                            <li class="nav-item">
                                <button class="nav-link" onclick="flutterwavePayment()" data-bs-toggle="pill">
                                    <img src="<?php echo e(custom_asset($flutterwave->logo)); ?>" alt="Degmark" class="img-fluis w-100">
                                </button>
                            </li>
                            <?php endif; ?>
                            <?php if($bankPayment->status == 1): ?>
                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="modal" data-bs-target="#bankPayment">
                                    <img src="<?php echo e(custom_asset($bankPayment->image)); ?>" alt="Degmark" class="img-fluis w-100">
                                </button>
                            </li>
                            <?php endif; ?>
                            <?php if($sslcommerz->status == 1): ?>
                            <li class="nav-item">
                                <form action="<?php echo e(url('/pay')); ?>" method="POST" class="needs-validation" id="sslForm">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="total_amount" value="<?php echo e($cartTotal); ?>">
                                    <input type="hidden" name="cart_qty" value="<?php echo e($cartQty); ?>">
                                </form>
                                <button class="nav-link" id="sslBtn" data-bs-toggle="pill">
                                    <img src="<?php echo e(custom_asset($sslcommerz->image)); ?>" alt="Degmark" class="img-fluis w-100">
                                </button>
                            </li>
                            <?php endif; ?>

                            <?php
                                $json_module_data = file_get_contents(base_path('modules_statuses.json'));
                                $module_status = json_decode($json_module_data);

                            ?>

                            <?php if(checkModule('PaymentGateway')): ?>
                                <?php echo $__env->make('checkout_for_addon_payment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            <?php endif; ?>



                        </ul>
                    </div>
                </div>

                <div class="col-xl-4 col-lg-5">
                    <div class="wsus__checkout_sidebar" id="sticky_sidebar">
                        <h3><?php echo e(__('user.Order Summary')); ?></h3>
                        <ul>
                            <?php $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <div class="img">
                                    <img src="<?php echo e(custom_asset($cart->options->image)); ?>" alt="checkout" class="img-fluid w-100">
                                </div>
                                <div class="text">
                                    <a href="<?php echo e(route('product-detail', $cart->options->slug)); ?>"><?php echo e(html_decode($cart->name)); ?></a>
                                    <p><?php echo e(__('user.Item by')); ?> <?php echo e(html_decode($cart->options->author)); ?></p>
                                    <p><?php echo e($cart->options->size ? html_decode($cart->options->size):''); ?></p>
                                    <p> <?php echo e($cart->options->price_type ? ucfirst(html_decode($cart->options->price_type)):''); ?></p>
                                    <h3>
                                        <?php if(session()->get('currency_position') == 'right'): ?>
                                            <?php echo e(html_decode($cart->price * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                        <?php else: ?>
                                            <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($cart->price * session()->get('currency_rate'))); ?>

                                        <?php endif; ?>
                                    </h3>
                                </div>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <?php if(Session::has('coupon')): ?>
                        <div class="wsus__checkout_sidebar_price">
                            <p><?php echo e(__('user.Subtotal')); ?>

                                <span>
                                    <?php if(session()->get('currency_position') == 'right'): ?>
                                        <?php echo e(html_decode($subTotal * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                    <?php else: ?>
                                        <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($subTotal * session()->get('currency_rate'))); ?>

                                    <?php endif; ?>
                                </span>
                            </p>
                            <p><?php echo e(__('user.Discount')); ?>

                                <span class="dis_amount">(-)
                                    <?php if(session()->get('currency_position') == 'right'): ?>
                                        <?php echo e(html_decode(session()->get('coupon')['discount_amount'] * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                    <?php else: ?>
                                        <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode(session()->get('coupon')['discount_amount'] * session()->get('currency_rate'))); ?>

                                    <?php endif; ?>
                                </span>
                            </p>
                            <p class="total"><?php echo e(__('user.Total')); ?>

                                <span>
                                    <?php if(session()->get('currency_position') == 'right'): ?>
                                        <?php echo e(html_decode(session()->get('coupon')['total_amount'] * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                    <?php else: ?>
                                        <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode(session()->get('coupon')['total_amount'] * session()->get('currency_rate'))); ?>

                                    <?php endif; ?>
                                </span>
                            </p>
                        </div>
                        <?php else: ?>
                        <div class="wsus__checkout_sidebar_price">
                            <p><?php echo e(__('user.Subtotal')); ?>

                                <span>
                                    <?php if(session()->get('currency_position') == 'right'): ?>
                                        <?php echo e(html_decode($subTotal * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                    <?php else: ?>
                                        <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($subTotal * session()->get('currency_rate'))); ?>

                                    <?php endif; ?>
                                </span>
                            </p>
                            <p><?php echo e(__('user.Discount')); ?>

                                <span class="dis_amount">(-)
                                    <?php if(session()->get('currency_position') == 'right'): ?>
                                        <?php echo e(html_decode(0 * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                    <?php else: ?>
                                        <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode(0 * session()->get('currency_rate'))); ?>

                                    <?php endif; ?>
                                </span>
                            </p>
                            <p class="total"><?php echo e(__('user.Total')); ?>

                                <span>
                                    <?php if(session()->get('currency_position') == 'right'): ?>
                                        <?php echo e(html_decode($subTotal * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                    <?php else: ?>
                                        <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($subTotal * session()->get('currency_rate'))); ?>

                                    <?php endif; ?>
                                </span>
                            </p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        CHECKOUT END
    ==============================-->

    <!--=============================
        RELATED PRODICT START
    ==============================-->
    <?php if($related_products->count() > 0): ?>
    <section class="wsus__related_product wsus__galley_2 pt_115 xs_pt_75 pb_120 xs_pb_80">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-8">
                    <div class="wsus__section_heading mb_15">
                        <h5><?php echo e(__('user.Save time with pre-installed software')); ?>.</h5>
                        <h2><?php echo e(__('user.Related Products')); ?>.</h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php $__empty_1 = true; $__currentLoopData = $related_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-xl-4 col-md-6">
                    <div class="wsus__gallery_item">
                        <div class="wsus__gallery_item_img">
                            <img src="<?php echo e(custom_asset($product->thumbnail_image)); ?>" alt="gallery" class="img-fluid w-100">
                            <ul class="wsus__gallery_item_overlay">
                                <li><a target="__blank" href="<?php echo e($product->preview_link); ?>"><?php echo e(__('user.Preview')); ?></a></li>
                                <li><a href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(__('user.Buy Now')); ?></a></li>
                            </ul>
                        </div>
                        <div class="wsus__gallery_item_text">
                            <?php
                                $review=App\Models\Review::where(['product_id' => $product->id, 'status' => 1])->get()->average('rating');
                                $sale=App\Models\OrderItem::where(['product_id' => $product->id])->get()->count();
                            ?>

                            <a class="title" href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(html_decode($product->productlangfrontend->name)); ?></a>

                            <p class="category"><?php echo e(__('user.By')); ?> <span><?php echo e(html_decode($product->author->name)); ?></span> <?php echo e(__('user.In')); ?> <a class="category"
                                    href="<?php echo e(route('products', ['category' => $product->category->slug])); ?>"><?php echo e($product->category->catlangfrontend->name); ?></a></p>

                            <p class="rating">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <?php if($i <= $review): ?>
                                    <i class="fas fa-star"></i>
                                    <?php else: ?>
                                    <i class="far fa-star"></i>
                                    <?php endif; ?>
                                <?php endfor; ?>
                                <span>(<?php echo e($review == 0 ? 0 : $review); ?>)</span>
                            </p>
                            <p class="price">
                                <?php if(session()->get('currency_position') == 'right'): ?>
                                    <?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                <?php else: ?>
                                    <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?>

                                <?php endif; ?>
                            </p>

                            <div class="like_and_sell">
                                <span class="download"><i class="fas fa-arrow-to-bottom"></i><?php echo e($sale); ?> <?php echo e(__('user.Sale')); ?></span>
                            </div>

                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12 text-center mt-5">
                    <h2 class="mt-5 text-danger"><?php echo e(__('user.Product Not Found')); ?></h2>
                </div>
                <?php endif; ?>
            </div>
            <a href="<?php echo e(route('products')); ?>" class="common_btn"><?php echo e(__('user.View All')); ?> <i class="far fa-long-arrow-right"></i></a>
        </div>
    </section>
    <?php endif; ?>
    <!--=============================
        RELATED PRODICT END
    ==============================-->

    <!-- Stripe Modal -->
    <div class="modal fade" id="stripeModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('user.Pay via Stripe')); ?></h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php
                    $stripe = App\Models\StripePayment::first();
                ?>
            <form  role="form" action="<?php echo e(route('pay-with-stripe')); ?>" method="post"
            class="require-validation"
            data-cc-on-file="false"
            data-stripe-publishable-key="<?php echo e($stripe->stripe_key); ?>"
            id="payment-form">
            <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-md-12 mt-2">
                        <div class="form-group">
                            <label for="card_number"><?php echo e(__('user.Card Number')); ?>*</label>
                            <input autocomplete='off' class='form-control card-number' size='20'
                            type='text' name="card_number" autocomplete="off">
                            <input type="hidden" name="total_amount" value="<?php echo e($cartTotal); ?>">
                            <input type="hidden" name="cart_qty" value="<?php echo e($cartQty); ?>">
                        </div>
                    </div>
                    <div class="col-md-12 mt-4">
                        <div class="form-group">
                            <label for="month"><?php echo e(__('user.Month')); ?>*</label>
                            <input input
                            class='form-control card-expiry-month' size='2'
                            type='text' name="month" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-12 mt-4">
                        <div class="form-group">
                            <label for="year"><?php echo e(__('user.Year')); ?>*</label>
                            <input class='form-control card-expiry-year' size='4'
                            type='text' name="year" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-12 my-4">
                        <div class="form-group">
                            <label for="cvc"><?php echo e(__('user.CVC')); ?>*</label>
                            <input autocomplete='off'
                            class='form-control card-cvc' size='4'
                            type='text' name="cvc" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class='row'>
                    <div class='col-md-12 error d-none'>
                        <div class='alert-danger alert'><?php echo e(__('user.Please correct the errors and try
                            again')); ?>.</div>
                    </div>
                </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><?php echo e(__('user.Cancel')); ?></button>
                <button class="btn btn-primary btn-block" type="submit"><?php echo e(__('user.Payment')); ?></button>
            </div>
            </form>
            </div>
        </div>
        </div>
    </div>


  
    <div class="wsus__payment_modal modal fade" id="bankPayment" data-bs-backdrop="static" data-bs-keyboard="false"
    tabindex="-1" aria-labelledby="bankPaymentLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="bankPaymentLabel"><?php echo e(__('user.Bank Payment')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="<?php echo e(route('bank-payment')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-xl-12 mb-4">
                                <p><?php echo clean(nl2br($bankPayment->account_info)); ?></p>
                            </div>

                            <div class="col-xl-12">
                                <textarea required cols="3" rows="3" name="tnx_info"  placeholder="<?php echo e(__('user.Type your transaction information')); ?>"></textarea>
                                <input type="hidden" name="total_amount" value="<?php echo e($cartTotal); ?>">
                                <input type="hidden" name="cart_qty" value="<?php echo e($cartQty); ?>">
                            </div>

                        </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('user.Close')); ?></button>
                    <button type="submit" class="btn btn-danger"><?php echo e(__('user.Submit')); ?></button>
                </div>
                </form>
            </div>
        </div>
    </div>





<?php $__env->stopSection(); ?>


    <?php $__env->startPush('frontend_js'); ?>
        <script>
            "use strict";
            $(document).ready(function(){
                $('#paypal').on('click',function(){
                    $('#paypalForm').submit();
                });
                $('#rajorpay').on('click',function(){
                    $('#rajorpayForm').submit();
                });

                $('#mollie').on('click',function(){
                    $('#mollieForm').submit();
                });

                $('#instamojo').on('click',function(){
                    $('#instamojoForm').submit();
                });
                $('#paystack').on('click',function(){
                    $('#paystackForm').submit();
                });
                $('#sslBtn').on('click',function(){
                    $('#sslForm').submit();
                });
            })
        </script>

        
        <script type="text/javascript" src="https://js.stripe.com/v2/"></script>
        <script type="text/javascript">
            $(function() {
                "use strict";

                var $form = $(".require-validation");

                $('form.require-validation').bind('submit', function(e) {
                    var $form = $(".require-validation"),
                    inputSelector = ['input[type=email]', 'input[type=password]',
                                    'input[type=text]', 'input[type=file]',
                                    'textarea'].join(', '),
                    $inputs = $form.find('.required').find(inputSelector),
                    $errorMessage = $form.find('div.error'),
                    valid = true;
                    $errorMessage.addClass('d-none');

                    $('.has-error').removeClass('has-error');
                    $inputs.each(function(i, el) {
                    var $input = $(el);
                    if ($input.val() === '') {
                        $input.parent().addClass('has-error');
                        $errorMessage.removeClass('d-none');
                        e.preventDefault();
                    }
                    });

                    if (!$form.data('cc-on-file')) {
                    e.preventDefault();
                    Stripe.setPublishableKey($form.data('stripe-publishable-key'));
                    Stripe.createToken({
                        number: $('.card-number').val(),
                        cvc: $('.card-cvc').val(),
                        exp_month: $('.card-expiry-month').val(),
                        exp_year: $('.card-expiry-year').val()
                    }, stripeResponseHandler);
                    }

                });

                function stripeResponseHandler(status, response) {
                    if (response.error) {
                        $('.error')
                            .removeClass('d-none')
                            .find('.alert')
                            .text(response.error.message);
                    } else {
                        /* token contains id, last4, and card type */
                        var token = response['id'];

                        $form.find('input[type=text]').empty();
                        $form.append("<input type='hidden' name='stripeToken' value='" + token + "'/>");
                        $form.get(0).submit();
                    }
                }

            });
        </script>
        


        

        <script src="https://js.paystack.co/v1/inline.js"></script>
        <?php

            $public_key = $paystack->paystack_public_key;
            $currency = $paystack->paystackcurrency->currency_code;
            $currency = strtoupper($currency);
            $ngn_amount = $cartTotal  * $paystack->paystackcurrency->currency_rate;
            $ngn_amount = $ngn_amount * 100;
            $ngn_amount = round($ngn_amount);
            $user=Auth::guard('web')->user();
        ?>
        <script>
            "use strict";
            function payWithPaystack(){
                var isDemo = "<?php echo e(env('APP_MODE')); ?>"
                if(isDemo == 'DEMO'){
                    toastr.error('This Is Demo Version. You Can Not Change Anything');
                    return;
                }
                var handler = PaystackPop.setup({
                    key: '<?php echo e($public_key); ?>',
                    email: '<?php echo e($user->email); ?>',
                    amount: '<?php echo e($ngn_amount); ?>',
                    currency: "<?php echo e($currency); ?>",
                    callback: function(response){
                    let reference = response.reference;
                    let tnx_id = response.transaction;
                    let _token = "<?php echo e(csrf_token()); ?>";
                    $.ajax({
                        type: "post",
                        data: {reference, tnx_id, _token},
                        url: "<?php echo e(url('pay-with-paystack')); ?>",
                        success: function(response) {
                            if(response.status == 'success'){
                                toastr.success(response.message);
                                window.location.href = "<?php echo e(route('payment-success')); ?>";
                            }else{
                                toastr.error(response.message);
                                window.location.reload();
                            }
                        },
                        error: function(response){
                                toastr.error('Server Error');
                                window.location.reload();
                        }
                    });
                    },
                    onClose: function(){
                        alert('window closed');
                    }
                });
                handler.openIframe();
            }
        </script>

        
        <script src="https://checkout.flutterwave.com/v3.js"></script>
        <?php
            $payable_amount = $cartTotal * $flutterwave->currency->currency_rate;
            $payable_amount = round($payable_amount, 2);
        ?>
        <script>
            "use strict";
            function flutterwavePayment() {

                var isDemo = "<?php echo e(env('APP_MODE')); ?>"
                if(isDemo == 'DEMO'){
                    toastr.error('This Is Demo Version. You Can Not Change Anything');
                    return;
                }


                FlutterwaveCheckout({
                    public_key: "<?php echo e($flutterwave->public_key); ?>",
                    tx_ref: "RX1",
                    amount: <?php echo e($payable_amount); ?>,
                    currency: "<?php echo e($flutterwave->currency->currency_code); ?>",
                    country: "<?php echo e($flutterwave->currency->country_code); ?>",
                    payment_options: " ",
                    customer: {
                    email: "<?php echo e($user->email); ?>",
                    phone_number: "<?php echo e($user->phone); ?>",
                    name: "<?php echo e($user->name); ?>",
                    },
                    callback: function (data) {

                        var tnx_id = data.transaction_id;
                        var _token = "<?php echo e(csrf_token()); ?>";
                        $.ajax({
                            type: 'post',
                            data : {tnx_id,_token},
                            url: "<?php echo e(url('pay-with-flutterwave')); ?>",
                            success: function (response) {
                                if(response.status == 'success'){
                                    toastr.success(response.message);
                                    window.location.href = "<?php echo e(route('payment-success')); ?>";
                                }else{
                                    toastr.error(response.message);
                                    window.location.reload();
                                }
                            },
                            error: function(err) {

                            }
                        });
                    },
                    customizations: {
                    title: "<?php echo e($flutterwave->title); ?>",
                    logo: "<?php echo e(custom_asset($flutterwave->logo)); ?>",
                    },
                });
            }
        </script>
        

    <?php $__env->stopPush(); ?>



<?php echo $__env->make($active_theme, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Projects\New folder\alasmart_cc\main_files\main_files\resources\views/checkout.blade.php ENDPATH**/ ?>