<div class="wsus__profile_header" style="background: url(<?php echo e(custom_asset('frontend/images/profile_header_bg.jpg')); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="wsus__profile_header_text">
                    <div class="img wow fadeInLeft" data-wow-duration="1s">
                        <?php if($user->image!=null): ?>
                        <img src="<?php echo e(custom_asset($user->image)); ?>" alt="profile" class="img-fluid w-100">
                        <?php elseif($user->provider=='google'): ?>
                        <img src="<?php echo e(custom_asset($user->provider_avatar)); ?>" alt="profile" class="img-fluid w-100">
                        <?php else: ?>
                        <img src="<?php echo e(custom_asset($setting->default_avatar)); ?>" alt="profile" class="img-fluid w-100">
                        <?php endif; ?>
                    </div>
                    <div class="text wow fadeInRight" data-wow-duration="1s">
                        <h2><?php echo e(html_decode($user->name)); ?></h2>
                        <p class="join"><span><?php echo e(__('user.Joined')); ?>:</span> <?php echo e(Carbon\Carbon::parse($user->created_at)->format('F Y')); ?></p>
                        <p class="skills"><?php echo e(html_decode($user->designation)); ?></p>
                        <?php
                            $review=App\Models\Review::where(['author_id' => $user->id, 'status' => 1])->get()->average('rating');
                            $votes=App\Models\Review::where(['author_id' => $user->id, 'status' => 1])->get()->count();
                            $total_product=App\Models\Product::with('category','author')->where(['author_id' => $user->id, 'status' => 1])->get()->count();
                            $total_sold=App\Models\OrderItem::with('product', 'variant', 'order')->where('author_id', $user->id)->get()->count();
                        ?>
                        <div class="rating">
                            <span>
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <?php if($i <= $review): ?>
                                    <i class="fas fa-star"></i>
                                    <?php else: ?>
                                    <i class="far fa-star"></i>
                                    <?php endif; ?>
                                <?php endfor; ?>
                            </span>
                            <p><?php echo e(__('user.Average rating of')); ?> <?php echo e($review==0?0:round($review, 1)); ?> <?php echo e(__('user.based on')); ?> <?php echo e($votes); ?> <?php echo e(__('user.votes')); ?></p>
                        </div>
                    </div>
                    <ul class="header_button d-flex flex-wrap">
                        <li>
                            <h4><i class="fas fa-box-full"></i> <?php echo e($total_product); ?></h4>
                            <p><?php echo e(__('user.Products')); ?></p>
                        </li>
                        <li>
                            <h4><i class="fas fa-cloud-download-alt"></i> <?php echo e($total_sold); ?></h4>
                            <p><?php echo e(__('user.Total sale')); ?></p>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container">
    <ul class="header_menu d-flex flex-wrap">
        <li><a class="<?php echo e(Route::is('dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('dashboard')); ?>"><i class="fal fa-layer-group"></i> <?php echo e(__('user.Overview')); ?></a>
        </li>
        <li><a class="<?php echo e(Route::is('portfolio') ? 'active' : ''); ?>" href="<?php echo e(route('portfolio')); ?>"><i class="far fa-box"></i> <?php echo e(__('user.Portfolio')); ?></a></li>
        <li><a class="<?php echo e(Route::is('download') ? 'active' : ''); ?>" href="<?php echo e(route('download')); ?>"><i class="far fa-download"></i> <?php echo e(__('user.Download File')); ?></a></li>
        <li><a class="<?php echo e(Route::is('collection') ? 'active' : ''); ?>" href="<?php echo e(route('collection')); ?>"><i class="far fa-heart" aria-hidden="true"></i> <?php echo e(__('user.Collection')); ?></a></li>

        <?php if($setting->commission_type == 'subscription'): ?>
            <?php
                $json_module_data = file_get_contents(base_path('modules_statuses.json'));
                $module_status = json_decode($json_module_data);
            ?>

            <?php if($module_status->Subscription): ?>
                <li><a class="<?php echo e(Route::is('provider.subscription-plan-user') ? 'active' : ''); ?>" href="<?php echo e(route('provider.subscription-plan-user')); ?>"><i class="far fa-usd-circle"></i> <?php echo e(__('user.Subscription')); ?> </a></li>
            <?php endif; ?>
        <?php else: ?>
            <li><a class="<?php echo e(Route::is('withdraw') ? 'active' : ''); ?>" href="<?php echo e(route('withdraw')); ?>"><i class="far fa-cogs"></i> <?php echo e(__('user.Withdraw')); ?> </a></li>
        <?php endif; ?>

    </ul>
<?php /**PATH C:\xampp\htdocs\Projects\New folder\alasmart_cc\main_files\main_files\resources\views/user/inc/profile_header.blade.php ENDPATH**/ ?>