<?php
// This file was auto-generated from sdk-root/src/data/cleanrooms/2022-02-17/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2022-02-17', 'endpointPrefix' => 'cleanrooms', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'AWS Clean Rooms Service', 'serviceId' => 'CleanRooms', 'signatureVersion' => 'v4', 'signingName' => 'cleanrooms', 'uid' => 'cleanrooms-2022-02-17', ], 'operations' => [ 'BatchGetSchema' => [ 'name' => 'BatchGetSchema', 'http' => [ 'method' => 'POST', 'requestUri' => '/collaborations/{collaborationIdentifier}/batch-schema', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchGetSchemaInput', ], 'output' => [ 'shape' => 'BatchGetSchemaOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'CreateCollaboration' => [ 'name' => 'CreateCollaboration', 'http' => [ 'method' => 'POST', 'requestUri' => '/collaborations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateCollaborationInput', ], 'output' => [ 'shape' => 'CreateCollaborationOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'CreateConfiguredTable' => [ 'name' => 'CreateConfiguredTable', 'http' => [ 'method' => 'POST', 'requestUri' => '/configuredTables', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateConfiguredTableInput', ], 'output' => [ 'shape' => 'CreateConfiguredTableOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'CreateConfiguredTableAnalysisRule' => [ 'name' => 'CreateConfiguredTableAnalysisRule', 'http' => [ 'method' => 'POST', 'requestUri' => '/configuredTables/{configuredTableIdentifier}/analysisRule', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateConfiguredTableAnalysisRuleInput', ], 'output' => [ 'shape' => 'CreateConfiguredTableAnalysisRuleOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'CreateConfiguredTableAssociation' => [ 'name' => 'CreateConfiguredTableAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/memberships/{membershipIdentifier}/configuredTableAssociations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateConfiguredTableAssociationInput', ], 'output' => [ 'shape' => 'CreateConfiguredTableAssociationOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'CreateMembership' => [ 'name' => 'CreateMembership', 'http' => [ 'method' => 'POST', 'requestUri' => '/memberships', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateMembershipInput', ], 'output' => [ 'shape' => 'CreateMembershipOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'DeleteCollaboration' => [ 'name' => 'DeleteCollaboration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/collaborations/{collaborationIdentifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteCollaborationInput', ], 'output' => [ 'shape' => 'DeleteCollaborationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DeleteConfiguredTable' => [ 'name' => 'DeleteConfiguredTable', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/configuredTables/{configuredTableIdentifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteConfiguredTableInput', ], 'output' => [ 'shape' => 'DeleteConfiguredTableOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DeleteConfiguredTableAnalysisRule' => [ 'name' => 'DeleteConfiguredTableAnalysisRule', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/configuredTables/{configuredTableIdentifier}/analysisRule/{analysisRuleType}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteConfiguredTableAnalysisRuleInput', ], 'output' => [ 'shape' => 'DeleteConfiguredTableAnalysisRuleOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DeleteConfiguredTableAssociation' => [ 'name' => 'DeleteConfiguredTableAssociation', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/memberships/{membershipIdentifier}/configuredTableAssociations/{configuredTableAssociationIdentifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteConfiguredTableAssociationInput', ], 'output' => [ 'shape' => 'DeleteConfiguredTableAssociationOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DeleteMember' => [ 'name' => 'DeleteMember', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/collaborations/{collaborationIdentifier}/member/{accountId}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteMemberInput', ], 'output' => [ 'shape' => 'DeleteMemberOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DeleteMembership' => [ 'name' => 'DeleteMembership', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/memberships/{membershipIdentifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteMembershipInput', ], 'output' => [ 'shape' => 'DeleteMembershipOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'GetCollaboration' => [ 'name' => 'GetCollaboration', 'http' => [ 'method' => 'GET', 'requestUri' => '/collaborations/{collaborationIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCollaborationInput', ], 'output' => [ 'shape' => 'GetCollaborationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'GetConfiguredTable' => [ 'name' => 'GetConfiguredTable', 'http' => [ 'method' => 'GET', 'requestUri' => '/configuredTables/{configuredTableIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetConfiguredTableInput', ], 'output' => [ 'shape' => 'GetConfiguredTableOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'GetConfiguredTableAnalysisRule' => [ 'name' => 'GetConfiguredTableAnalysisRule', 'http' => [ 'method' => 'GET', 'requestUri' => '/configuredTables/{configuredTableIdentifier}/analysisRule/{analysisRuleType}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetConfiguredTableAnalysisRuleInput', ], 'output' => [ 'shape' => 'GetConfiguredTableAnalysisRuleOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'GetConfiguredTableAssociation' => [ 'name' => 'GetConfiguredTableAssociation', 'http' => [ 'method' => 'GET', 'requestUri' => '/memberships/{membershipIdentifier}/configuredTableAssociations/{configuredTableAssociationIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetConfiguredTableAssociationInput', ], 'output' => [ 'shape' => 'GetConfiguredTableAssociationOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'GetMembership' => [ 'name' => 'GetMembership', 'http' => [ 'method' => 'GET', 'requestUri' => '/memberships/{membershipIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMembershipInput', ], 'output' => [ 'shape' => 'GetMembershipOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'GetProtectedQuery' => [ 'name' => 'GetProtectedQuery', 'http' => [ 'method' => 'GET', 'requestUri' => '/memberships/{membershipIdentifier}/protectedQueries/{protectedQueryIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetProtectedQueryInput', ], 'output' => [ 'shape' => 'GetProtectedQueryOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'GetSchema' => [ 'name' => 'GetSchema', 'http' => [ 'method' => 'GET', 'requestUri' => '/collaborations/{collaborationIdentifier}/schemas/{name}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSchemaInput', ], 'output' => [ 'shape' => 'GetSchemaOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'GetSchemaAnalysisRule' => [ 'name' => 'GetSchemaAnalysisRule', 'http' => [ 'method' => 'GET', 'requestUri' => '/collaborations/{collaborationIdentifier}/schemas/{name}/analysisRule/{type}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSchemaAnalysisRuleInput', ], 'output' => [ 'shape' => 'GetSchemaAnalysisRuleOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListCollaborations' => [ 'name' => 'ListCollaborations', 'http' => [ 'method' => 'GET', 'requestUri' => '/collaborations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListCollaborationsInput', ], 'output' => [ 'shape' => 'ListCollaborationsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListConfiguredTableAssociations' => [ 'name' => 'ListConfiguredTableAssociations', 'http' => [ 'method' => 'GET', 'requestUri' => '/memberships/{membershipIdentifier}/configuredTableAssociations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListConfiguredTableAssociationsInput', ], 'output' => [ 'shape' => 'ListConfiguredTableAssociationsOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListConfiguredTables' => [ 'name' => 'ListConfiguredTables', 'http' => [ 'method' => 'GET', 'requestUri' => '/configuredTables', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListConfiguredTablesInput', ], 'output' => [ 'shape' => 'ListConfiguredTablesOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListMembers' => [ 'name' => 'ListMembers', 'http' => [ 'method' => 'GET', 'requestUri' => '/collaborations/{collaborationIdentifier}/members', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMembersInput', ], 'output' => [ 'shape' => 'ListMembersOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListMemberships' => [ 'name' => 'ListMemberships', 'http' => [ 'method' => 'GET', 'requestUri' => '/memberships', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMembershipsInput', ], 'output' => [ 'shape' => 'ListMembershipsOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListProtectedQueries' => [ 'name' => 'ListProtectedQueries', 'http' => [ 'method' => 'GET', 'requestUri' => '/memberships/{membershipIdentifier}/protectedQueries', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListProtectedQueriesInput', ], 'output' => [ 'shape' => 'ListProtectedQueriesOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListSchemas' => [ 'name' => 'ListSchemas', 'http' => [ 'method' => 'GET', 'requestUri' => '/collaborations/{collaborationIdentifier}/schemas', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSchemasInput', ], 'output' => [ 'shape' => 'ListSchemasOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceInput', ], 'output' => [ 'shape' => 'ListTagsForResourceOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'StartProtectedQuery' => [ 'name' => 'StartProtectedQuery', 'http' => [ 'method' => 'POST', 'requestUri' => '/memberships/{membershipIdentifier}/protectedQueries', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartProtectedQueryInput', ], 'output' => [ 'shape' => 'StartProtectedQueryOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceInput', ], 'output' => [ 'shape' => 'TagResourceOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceInput', ], 'output' => [ 'shape' => 'UntagResourceOutput', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ValidationException', ], ], ], 'UpdateCollaboration' => [ 'name' => 'UpdateCollaboration', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/collaborations/{collaborationIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateCollaborationInput', ], 'output' => [ 'shape' => 'UpdateCollaborationOutput', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'UpdateConfiguredTable' => [ 'name' => 'UpdateConfiguredTable', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/configuredTables/{configuredTableIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateConfiguredTableInput', ], 'output' => [ 'shape' => 'UpdateConfiguredTableOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'UpdateConfiguredTableAnalysisRule' => [ 'name' => 'UpdateConfiguredTableAnalysisRule', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/configuredTables/{configuredTableIdentifier}/analysisRule/{analysisRuleType}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateConfiguredTableAnalysisRuleInput', ], 'output' => [ 'shape' => 'UpdateConfiguredTableAnalysisRuleOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'UpdateConfiguredTableAssociation' => [ 'name' => 'UpdateConfiguredTableAssociation', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/memberships/{membershipIdentifier}/configuredTableAssociations/{configuredTableAssociationIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateConfiguredTableAssociationInput', ], 'output' => [ 'shape' => 'UpdateConfiguredTableAssociationOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'UpdateMembership' => [ 'name' => 'UpdateMembership', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/memberships/{membershipIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateMembershipInput', ], 'output' => [ 'shape' => 'UpdateMembershipOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'UpdateProtectedQuery' => [ 'name' => 'UpdateProtectedQuery', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/memberships/{membershipIdentifier}/protectedQueries/{protectedQueryIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateProtectedQueryInput', ], 'output' => [ 'shape' => 'UpdateProtectedQueryOutput', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], 'reason' => [ 'shape' => 'AccessDeniedExceptionReason', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccessDeniedExceptionReason' => [ 'type' => 'string', 'enum' => [ 'INSUFFICIENT_PERMISSIONS', ], ], 'AccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '\\d+', ], 'AggregateColumn' => [ 'type' => 'structure', 'required' => [ 'columnNames', 'function', ], 'members' => [ 'columnNames' => [ 'shape' => 'AggregateColumnColumnNamesList', ], 'function' => [ 'shape' => 'AggregateFunctionName', ], ], ], 'AggregateColumnColumnNamesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AnalysisRuleColumnName', ], 'min' => 1, ], 'AggregateFunctionName' => [ 'type' => 'string', 'enum' => [ 'SUM', 'SUM_DISTINCT', 'COUNT', 'COUNT_DISTINCT', 'AVG', ], ], 'AggregationConstraint' => [ 'type' => 'structure', 'required' => [ 'columnName', 'minimum', 'type', ], 'members' => [ 'columnName' => [ 'shape' => 'AnalysisRuleColumnName', ], 'minimum' => [ 'shape' => 'AggregationConstraintMinimumInteger', ], 'type' => [ 'shape' => 'AggregationType', ], ], ], 'AggregationConstraintMinimumInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 100000, 'min' => 2, ], 'AggregationConstraints' => [ 'type' => 'list', 'member' => [ 'shape' => 'AggregationConstraint', ], 'min' => 1, ], 'AggregationType' => [ 'type' => 'string', 'enum' => [ 'COUNT_DISTINCT', ], ], 'AllowedColumnList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ColumnName', ], 'max' => 100, 'min' => 1, ], 'AnalysisMethod' => [ 'type' => 'string', 'enum' => [ 'DIRECT_QUERY', ], ], 'AnalysisRule' => [ 'type' => 'structure', 'required' => [ 'collaborationId', 'type', 'name', 'createTime', 'updateTime', 'policy', ], 'members' => [ 'collaborationId' => [ 'shape' => 'CollaborationIdentifier', ], 'type' => [ 'shape' => 'AnalysisRuleType', ], 'name' => [ 'shape' => 'TableAlias', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'policy' => [ 'shape' => 'AnalysisRulePolicy', ], ], ], 'AnalysisRuleAggregation' => [ 'type' => 'structure', 'required' => [ 'aggregateColumns', 'joinColumns', 'dimensionColumns', 'scalarFunctions', 'outputConstraints', ], 'members' => [ 'aggregateColumns' => [ 'shape' => 'AnalysisRuleAggregationAggregateColumnsList', ], 'joinColumns' => [ 'shape' => 'AnalysisRuleColumnList', ], 'joinRequired' => [ 'shape' => 'JoinRequiredOption', ], 'dimensionColumns' => [ 'shape' => 'AnalysisRuleColumnList', ], 'scalarFunctions' => [ 'shape' => 'ScalarFunctionsList', ], 'outputConstraints' => [ 'shape' => 'AggregationConstraints', ], ], ], 'AnalysisRuleAggregationAggregateColumnsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AggregateColumn', ], 'min' => 1, ], 'AnalysisRuleColumnList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AnalysisRuleColumnName', ], ], 'AnalysisRuleColumnName' => [ 'type' => 'string', 'max' => 127, 'min' => 1, 'pattern' => '[a-z0-9_](([a-z0-9_ ]+-)*([a-z0-9_ ]+))?', ], 'AnalysisRuleList' => [ 'type' => 'structure', 'required' => [ 'joinColumns', 'listColumns', ], 'members' => [ 'joinColumns' => [ 'shape' => 'AnalysisRuleListJoinColumnsList', ], 'listColumns' => [ 'shape' => 'AnalysisRuleColumnList', ], ], ], 'AnalysisRuleListJoinColumnsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AnalysisRuleColumnName', ], 'min' => 1, ], 'AnalysisRulePolicy' => [ 'type' => 'structure', 'members' => [ 'v1' => [ 'shape' => 'AnalysisRulePolicyV1', ], ], 'union' => true, ], 'AnalysisRulePolicyV1' => [ 'type' => 'structure', 'members' => [ 'list' => [ 'shape' => 'AnalysisRuleList', ], 'aggregation' => [ 'shape' => 'AnalysisRuleAggregation', ], ], 'union' => true, ], 'AnalysisRuleType' => [ 'type' => 'string', 'enum' => [ 'AGGREGATION', 'LIST', ], ], 'AnalysisRuleTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AnalysisRuleType', ], ], 'BatchGetSchemaError' => [ 'type' => 'structure', 'required' => [ 'name', 'code', 'message', ], 'members' => [ 'name' => [ 'shape' => 'TableAlias', ], 'code' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'BatchGetSchemaErrorList' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchGetSchemaError', ], 'max' => 25, 'min' => 0, ], 'BatchGetSchemaInput' => [ 'type' => 'structure', 'required' => [ 'collaborationIdentifier', 'names', ], 'members' => [ 'collaborationIdentifier' => [ 'shape' => 'CollaborationIdentifier', 'location' => 'uri', 'locationName' => 'collaborationIdentifier', ], 'names' => [ 'shape' => 'TableAliasList', ], ], ], 'BatchGetSchemaOutput' => [ 'type' => 'structure', 'required' => [ 'schemas', 'errors', ], 'members' => [ 'schemas' => [ 'shape' => 'SchemaList', ], 'errors' => [ 'shape' => 'BatchGetSchemaErrorList', ], ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'CleanroomsArn' => [ 'type' => 'string', 'max' => 100, 'min' => 0, 'pattern' => 'arn:aws:cleanrooms:[\\w]{2}-[\\w]{4,9}-[\\d]:[\\d]{12}:[\\d\\w/-]+', ], 'Collaboration' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'name', 'creatorAccountId', 'creatorDisplayName', 'createTime', 'updateTime', 'memberStatus', 'queryLogStatus', ], 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'arn' => [ 'shape' => 'CollaborationArn', ], 'name' => [ 'shape' => 'CollaborationName', ], 'description' => [ 'shape' => 'CollaborationDescription', ], 'creatorAccountId' => [ 'shape' => 'AccountId', ], 'creatorDisplayName' => [ 'shape' => 'DisplayName', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'memberStatus' => [ 'shape' => 'MemberStatus', ], 'membershipId' => [ 'shape' => 'UUID', ], 'membershipArn' => [ 'shape' => 'MembershipArn', ], 'dataEncryptionMetadata' => [ 'shape' => 'DataEncryptionMetadata', ], 'queryLogStatus' => [ 'shape' => 'CollaborationQueryLogStatus', ], ], ], 'CollaborationArn' => [ 'type' => 'string', 'max' => 100, 'min' => 0, 'pattern' => 'arn:aws:[\\w]+:[\\w]{2}-[\\w]{4,9}-[\\d]:[\\d]{12}:collaboration/[\\d\\w-]+', ], 'CollaborationDescription' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '(?!\\s*$)[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDBFF-\\uDC00\\uDFFF\\t\\r\\n]*', ], 'CollaborationIdentifier' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '.*[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}.*', ], 'CollaborationName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '(?!\\s*$)[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDBFF-\\uDC00\\uDFFF\\t]*', ], 'CollaborationQueryLogStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'CollaborationSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'name', 'creatorAccountId', 'creatorDisplayName', 'createTime', 'updateTime', 'memberStatus', ], 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'arn' => [ 'shape' => 'CollaborationArn', ], 'name' => [ 'shape' => 'CollaborationName', ], 'creatorAccountId' => [ 'shape' => 'AccountId', ], 'creatorDisplayName' => [ 'shape' => 'DisplayName', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'memberStatus' => [ 'shape' => 'MemberStatus', ], 'membershipId' => [ 'shape' => 'UUID', ], 'membershipArn' => [ 'shape' => 'MembershipArn', ], ], ], 'CollaborationSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CollaborationSummary', ], ], 'Column' => [ 'type' => 'structure', 'required' => [ 'name', 'type', ], 'members' => [ 'name' => [ 'shape' => 'ColumnName', ], 'type' => [ 'shape' => 'ColumnTypeString', ], ], ], 'ColumnList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Column', ], ], 'ColumnName' => [ 'type' => 'string', 'max' => 128, 'min' => 0, 'pattern' => '[a-z0-9_](([a-z0-9_ ]+-)*([a-z0-9_ ]+))?', ], 'ColumnTypeString' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDBFF-\\uDC00\\uDFFF\\t]*', ], 'ConfiguredTable' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'name', 'tableReference', 'createTime', 'updateTime', 'analysisRuleTypes', 'analysisMethod', 'allowedColumns', ], 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'arn' => [ 'shape' => 'ConfiguredTableArn', ], 'name' => [ 'shape' => 'DisplayName', ], 'description' => [ 'shape' => 'TableDescription', ], 'tableReference' => [ 'shape' => 'TableReference', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'analysisRuleTypes' => [ 'shape' => 'ConfiguredTableAnalysisRuleTypeList', ], 'analysisMethod' => [ 'shape' => 'AnalysisMethod', ], 'allowedColumns' => [ 'shape' => 'AllowedColumnList', ], ], ], 'ConfiguredTableAnalysisRule' => [ 'type' => 'structure', 'required' => [ 'configuredTableId', 'configuredTableArn', 'policy', 'type', 'createTime', 'updateTime', ], 'members' => [ 'configuredTableId' => [ 'shape' => 'UUID', ], 'configuredTableArn' => [ 'shape' => 'ConfiguredTableArn', ], 'policy' => [ 'shape' => 'ConfiguredTableAnalysisRulePolicy', ], 'type' => [ 'shape' => 'ConfiguredTableAnalysisRuleType', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], ], ], 'ConfiguredTableAnalysisRulePolicy' => [ 'type' => 'structure', 'members' => [ 'v1' => [ 'shape' => 'ConfiguredTableAnalysisRulePolicyV1', ], ], 'union' => true, ], 'ConfiguredTableAnalysisRulePolicyV1' => [ 'type' => 'structure', 'members' => [ 'list' => [ 'shape' => 'AnalysisRuleList', ], 'aggregation' => [ 'shape' => 'AnalysisRuleAggregation', ], ], 'union' => true, ], 'ConfiguredTableAnalysisRuleType' => [ 'type' => 'string', 'enum' => [ 'AGGREGATION', 'LIST', ], ], 'ConfiguredTableAnalysisRuleTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfiguredTableAnalysisRuleType', ], ], 'ConfiguredTableArn' => [ 'type' => 'string', 'max' => 100, 'min' => 0, 'pattern' => 'arn:aws:[\\w]+:[\\w]{2}-[\\w]{4,9}-[\\d]:[\\d]{12}:configuredTable/[\\d\\w-]+', ], 'ConfiguredTableAssociation' => [ 'type' => 'structure', 'required' => [ 'arn', 'id', 'configuredTableId', 'configuredTableArn', 'membershipId', 'membershipArn', 'roleArn', 'name', 'createTime', 'updateTime', ], 'members' => [ 'arn' => [ 'shape' => 'ConfiguredTableAssociationArn', ], 'id' => [ 'shape' => 'UUID', ], 'configuredTableId' => [ 'shape' => 'UUID', ], 'configuredTableArn' => [ 'shape' => 'ConfiguredTableArn', ], 'membershipId' => [ 'shape' => 'UUID', ], 'membershipArn' => [ 'shape' => 'MembershipArn', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'name' => [ 'shape' => 'TableAlias', ], 'description' => [ 'shape' => 'TableDescription', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], ], ], 'ConfiguredTableAssociationArn' => [ 'type' => 'string', 'max' => 100, 'min' => 0, 'pattern' => 'arn:aws:[\\w]+:[\\w]{2}-[\\w]{4,9}-[\\d]:[\\d]{12}:configuredTableAssociation/[\\d\\w-]+/[\\d\\w-]+', ], 'ConfiguredTableAssociationIdentifier' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '.*[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}.*', ], 'ConfiguredTableAssociationSummary' => [ 'type' => 'structure', 'required' => [ 'configuredTableId', 'membershipId', 'membershipArn', 'name', 'createTime', 'updateTime', 'id', 'arn', ], 'members' => [ 'configuredTableId' => [ 'shape' => 'UUID', ], 'membershipId' => [ 'shape' => 'MembershipIdentifier', ], 'membershipArn' => [ 'shape' => 'MembershipArn', ], 'name' => [ 'shape' => 'TableAlias', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'id' => [ 'shape' => 'UUID', ], 'arn' => [ 'shape' => 'ConfiguredTableAssociationArn', ], ], ], 'ConfiguredTableAssociationSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfiguredTableAssociationSummary', ], ], 'ConfiguredTableIdentifier' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '.*[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}.*', ], 'ConfiguredTableSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'name', 'createTime', 'updateTime', 'analysisRuleTypes', 'analysisMethod', ], 'members' => [ 'id' => [ 'shape' => 'ConfiguredTableIdentifier', ], 'arn' => [ 'shape' => 'ConfiguredTableArn', ], 'name' => [ 'shape' => 'DisplayName', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'analysisRuleTypes' => [ 'shape' => 'ConfiguredTableAnalysisRuleTypeList', ], 'analysisMethod' => [ 'shape' => 'AnalysisMethod', ], ], ], 'ConfiguredTableSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfiguredTableSummary', ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'ResourceType', ], 'reason' => [ 'shape' => 'ConflictExceptionReason', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConflictExceptionReason' => [ 'type' => 'string', 'enum' => [ 'ALREADY_EXISTS', 'SUBRESOURCES_EXIST', 'INVALID_STATE', ], ], 'CreateCollaborationInput' => [ 'type' => 'structure', 'required' => [ 'members', 'name', 'description', 'creatorMemberAbilities', 'creatorDisplayName', 'queryLogStatus', ], 'members' => [ 'members' => [ 'shape' => 'MemberList', ], 'name' => [ 'shape' => 'CollaborationName', ], 'description' => [ 'shape' => 'CollaborationDescription', ], 'creatorMemberAbilities' => [ 'shape' => 'MemberAbilities', ], 'creatorDisplayName' => [ 'shape' => 'DisplayName', ], 'dataEncryptionMetadata' => [ 'shape' => 'DataEncryptionMetadata', ], 'queryLogStatus' => [ 'shape' => 'CollaborationQueryLogStatus', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateCollaborationOutput' => [ 'type' => 'structure', 'required' => [ 'collaboration', ], 'members' => [ 'collaboration' => [ 'shape' => 'Collaboration', ], ], ], 'CreateConfiguredTableAnalysisRuleInput' => [ 'type' => 'structure', 'required' => [ 'configuredTableIdentifier', 'analysisRuleType', 'analysisRulePolicy', ], 'members' => [ 'configuredTableIdentifier' => [ 'shape' => 'ConfiguredTableIdentifier', 'location' => 'uri', 'locationName' => 'configuredTableIdentifier', ], 'analysisRuleType' => [ 'shape' => 'ConfiguredTableAnalysisRuleType', ], 'analysisRulePolicy' => [ 'shape' => 'ConfiguredTableAnalysisRulePolicy', ], ], ], 'CreateConfiguredTableAnalysisRuleOutput' => [ 'type' => 'structure', 'required' => [ 'analysisRule', ], 'members' => [ 'analysisRule' => [ 'shape' => 'ConfiguredTableAnalysisRule', ], ], ], 'CreateConfiguredTableAssociationInput' => [ 'type' => 'structure', 'required' => [ 'name', 'membershipIdentifier', 'configuredTableIdentifier', 'roleArn', ], 'members' => [ 'name' => [ 'shape' => 'TableAlias', ], 'description' => [ 'shape' => 'TableDescription', ], 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], 'configuredTableIdentifier' => [ 'shape' => 'ConfiguredTableIdentifier', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateConfiguredTableAssociationOutput' => [ 'type' => 'structure', 'required' => [ 'configuredTableAssociation', ], 'members' => [ 'configuredTableAssociation' => [ 'shape' => 'ConfiguredTableAssociation', ], ], ], 'CreateConfiguredTableInput' => [ 'type' => 'structure', 'required' => [ 'name', 'tableReference', 'allowedColumns', 'analysisMethod', ], 'members' => [ 'name' => [ 'shape' => 'DisplayName', ], 'description' => [ 'shape' => 'TableDescription', ], 'tableReference' => [ 'shape' => 'TableReference', ], 'allowedColumns' => [ 'shape' => 'AllowedColumnList', ], 'analysisMethod' => [ 'shape' => 'AnalysisMethod', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateConfiguredTableOutput' => [ 'type' => 'structure', 'required' => [ 'configuredTable', ], 'members' => [ 'configuredTable' => [ 'shape' => 'ConfiguredTable', ], ], ], 'CreateMembershipInput' => [ 'type' => 'structure', 'required' => [ 'collaborationIdentifier', 'queryLogStatus', ], 'members' => [ 'collaborationIdentifier' => [ 'shape' => 'CollaborationIdentifier', ], 'queryLogStatus' => [ 'shape' => 'MembershipQueryLogStatus', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateMembershipOutput' => [ 'type' => 'structure', 'required' => [ 'membership', ], 'members' => [ 'membership' => [ 'shape' => 'Membership', ], ], ], 'DataEncryptionMetadata' => [ 'type' => 'structure', 'required' => [ 'allowCleartext', 'allowDuplicates', 'allowJoinsOnColumnsWithDifferentNames', 'preserveNulls', ], 'members' => [ 'allowCleartext' => [ 'shape' => 'Boolean', ], 'allowDuplicates' => [ 'shape' => 'Boolean', ], 'allowJoinsOnColumnsWithDifferentNames' => [ 'shape' => 'Boolean', ], 'preserveNulls' => [ 'shape' => 'Boolean', ], ], ], 'DeleteCollaborationInput' => [ 'type' => 'structure', 'required' => [ 'collaborationIdentifier', ], 'members' => [ 'collaborationIdentifier' => [ 'shape' => 'CollaborationIdentifier', 'location' => 'uri', 'locationName' => 'collaborationIdentifier', ], ], ], 'DeleteCollaborationOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteConfiguredTableAnalysisRuleInput' => [ 'type' => 'structure', 'required' => [ 'configuredTableIdentifier', 'analysisRuleType', ], 'members' => [ 'configuredTableIdentifier' => [ 'shape' => 'ConfiguredTableIdentifier', 'location' => 'uri', 'locationName' => 'configuredTableIdentifier', ], 'analysisRuleType' => [ 'shape' => 'ConfiguredTableAnalysisRuleType', 'location' => 'uri', 'locationName' => 'analysisRuleType', ], ], ], 'DeleteConfiguredTableAnalysisRuleOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteConfiguredTableAssociationInput' => [ 'type' => 'structure', 'required' => [ 'configuredTableAssociationIdentifier', 'membershipIdentifier', ], 'members' => [ 'configuredTableAssociationIdentifier' => [ 'shape' => 'ConfiguredTableAssociationIdentifier', 'location' => 'uri', 'locationName' => 'configuredTableAssociationIdentifier', ], 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], ], ], 'DeleteConfiguredTableAssociationOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteConfiguredTableInput' => [ 'type' => 'structure', 'required' => [ 'configuredTableIdentifier', ], 'members' => [ 'configuredTableIdentifier' => [ 'shape' => 'ConfiguredTableIdentifier', 'location' => 'uri', 'locationName' => 'configuredTableIdentifier', ], ], ], 'DeleteConfiguredTableOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteMemberInput' => [ 'type' => 'structure', 'required' => [ 'collaborationIdentifier', 'accountId', ], 'members' => [ 'collaborationIdentifier' => [ 'shape' => 'CollaborationIdentifier', 'location' => 'uri', 'locationName' => 'collaborationIdentifier', ], 'accountId' => [ 'shape' => 'AccountId', 'location' => 'uri', 'locationName' => 'accountId', ], ], ], 'DeleteMemberOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteMembershipInput' => [ 'type' => 'structure', 'required' => [ 'membershipIdentifier', ], 'members' => [ 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], ], ], 'DeleteMembershipOutput' => [ 'type' => 'structure', 'members' => [], ], 'DisplayName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '(?!\\s*$)[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDBFF-\\uDC00\\uDFFF\\t]*', ], 'Double' => [ 'type' => 'double', 'box' => true, ], 'FilterableMemberStatus' => [ 'type' => 'string', 'enum' => [ 'INVITED', 'ACTIVE', ], ], 'GetCollaborationInput' => [ 'type' => 'structure', 'required' => [ 'collaborationIdentifier', ], 'members' => [ 'collaborationIdentifier' => [ 'shape' => 'CollaborationIdentifier', 'location' => 'uri', 'locationName' => 'collaborationIdentifier', ], ], ], 'GetCollaborationOutput' => [ 'type' => 'structure', 'required' => [ 'collaboration', ], 'members' => [ 'collaboration' => [ 'shape' => 'Collaboration', ], ], ], 'GetConfiguredTableAnalysisRuleInput' => [ 'type' => 'structure', 'required' => [ 'configuredTableIdentifier', 'analysisRuleType', ], 'members' => [ 'configuredTableIdentifier' => [ 'shape' => 'ConfiguredTableIdentifier', 'location' => 'uri', 'locationName' => 'configuredTableIdentifier', ], 'analysisRuleType' => [ 'shape' => 'ConfiguredTableAnalysisRuleType', 'location' => 'uri', 'locationName' => 'analysisRuleType', ], ], ], 'GetConfiguredTableAnalysisRuleOutput' => [ 'type' => 'structure', 'required' => [ 'analysisRule', ], 'members' => [ 'analysisRule' => [ 'shape' => 'ConfiguredTableAnalysisRule', ], ], ], 'GetConfiguredTableAssociationInput' => [ 'type' => 'structure', 'required' => [ 'configuredTableAssociationIdentifier', 'membershipIdentifier', ], 'members' => [ 'configuredTableAssociationIdentifier' => [ 'shape' => 'ConfiguredTableAssociationIdentifier', 'location' => 'uri', 'locationName' => 'configuredTableAssociationIdentifier', ], 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], ], ], 'GetConfiguredTableAssociationOutput' => [ 'type' => 'structure', 'required' => [ 'configuredTableAssociation', ], 'members' => [ 'configuredTableAssociation' => [ 'shape' => 'ConfiguredTableAssociation', ], ], ], 'GetConfiguredTableInput' => [ 'type' => 'structure', 'required' => [ 'configuredTableIdentifier', ], 'members' => [ 'configuredTableIdentifier' => [ 'shape' => 'ConfiguredTableIdentifier', 'location' => 'uri', 'locationName' => 'configuredTableIdentifier', ], ], ], 'GetConfiguredTableOutput' => [ 'type' => 'structure', 'required' => [ 'configuredTable', ], 'members' => [ 'configuredTable' => [ 'shape' => 'ConfiguredTable', ], ], ], 'GetMembershipInput' => [ 'type' => 'structure', 'required' => [ 'membershipIdentifier', ], 'members' => [ 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], ], ], 'GetMembershipOutput' => [ 'type' => 'structure', 'required' => [ 'membership', ], 'members' => [ 'membership' => [ 'shape' => 'Membership', ], ], ], 'GetProtectedQueryInput' => [ 'type' => 'structure', 'required' => [ 'membershipIdentifier', 'protectedQueryIdentifier', ], 'members' => [ 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], 'protectedQueryIdentifier' => [ 'shape' => 'ProtectedQueryIdentifier', 'location' => 'uri', 'locationName' => 'protectedQueryIdentifier', ], ], ], 'GetProtectedQueryOutput' => [ 'type' => 'structure', 'required' => [ 'protectedQuery', ], 'members' => [ 'protectedQuery' => [ 'shape' => 'ProtectedQuery', ], ], ], 'GetSchemaAnalysisRuleInput' => [ 'type' => 'structure', 'required' => [ 'collaborationIdentifier', 'name', 'type', ], 'members' => [ 'collaborationIdentifier' => [ 'shape' => 'CollaborationIdentifier', 'location' => 'uri', 'locationName' => 'collaborationIdentifier', ], 'name' => [ 'shape' => 'TableAlias', 'location' => 'uri', 'locationName' => 'name', ], 'type' => [ 'shape' => 'AnalysisRuleType', 'location' => 'uri', 'locationName' => 'type', ], ], ], 'GetSchemaAnalysisRuleOutput' => [ 'type' => 'structure', 'required' => [ 'analysisRule', ], 'members' => [ 'analysisRule' => [ 'shape' => 'AnalysisRule', ], ], ], 'GetSchemaInput' => [ 'type' => 'structure', 'required' => [ 'collaborationIdentifier', 'name', ], 'members' => [ 'collaborationIdentifier' => [ 'shape' => 'CollaborationIdentifier', 'location' => 'uri', 'locationName' => 'collaborationIdentifier', ], 'name' => [ 'shape' => 'TableAlias', 'location' => 'uri', 'locationName' => 'name', ], ], ], 'GetSchemaOutput' => [ 'type' => 'structure', 'required' => [ 'schema', ], 'members' => [ 'schema' => [ 'shape' => 'Schema', ], ], ], 'GlueResourceName' => [ 'type' => 'string', 'max' => 128, 'min' => 0, 'pattern' => '[a-zA-Z0-9_](([a-zA-Z0-9_ ]+-)*([a-zA-Z0-9_ ]+))?', ], 'GlueTableReference' => [ 'type' => 'structure', 'required' => [ 'tableName', 'databaseName', ], 'members' => [ 'tableName' => [ 'shape' => 'GlueResourceName', ], 'databaseName' => [ 'shape' => 'GlueResourceName', ], ], ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'JoinRequiredOption' => [ 'type' => 'string', 'enum' => [ 'QUERY_RUNNER', ], ], 'KeyPrefix' => [ 'type' => 'string', 'pattern' => '[\\w!.*/-]*', ], 'ListCollaborationsInput' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'memberStatus' => [ 'shape' => 'FilterableMemberStatus', 'location' => 'querystring', 'locationName' => 'memberStatus', ], ], ], 'ListCollaborationsOutput' => [ 'type' => 'structure', 'required' => [ 'collaborationList', ], 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'collaborationList' => [ 'shape' => 'CollaborationSummaryList', ], ], ], 'ListConfiguredTableAssociationsInput' => [ 'type' => 'structure', 'required' => [ 'membershipIdentifier', ], 'members' => [ 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListConfiguredTableAssociationsOutput' => [ 'type' => 'structure', 'required' => [ 'configuredTableAssociationSummaries', ], 'members' => [ 'configuredTableAssociationSummaries' => [ 'shape' => 'ConfiguredTableAssociationSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListConfiguredTablesInput' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListConfiguredTablesOutput' => [ 'type' => 'structure', 'required' => [ 'configuredTableSummaries', ], 'members' => [ 'configuredTableSummaries' => [ 'shape' => 'ConfiguredTableSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListMembersInput' => [ 'type' => 'structure', 'required' => [ 'collaborationIdentifier', ], 'members' => [ 'collaborationIdentifier' => [ 'shape' => 'CollaborationIdentifier', 'location' => 'uri', 'locationName' => 'collaborationIdentifier', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListMembersOutput' => [ 'type' => 'structure', 'required' => [ 'memberSummaries', ], 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'memberSummaries' => [ 'shape' => 'MemberSummaryList', ], ], ], 'ListMembershipsInput' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'status' => [ 'shape' => 'MembershipStatus', 'location' => 'querystring', 'locationName' => 'status', ], ], ], 'ListMembershipsOutput' => [ 'type' => 'structure', 'required' => [ 'membershipSummaries', ], 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'membershipSummaries' => [ 'shape' => 'MembershipSummaryList', ], ], ], 'ListProtectedQueriesInput' => [ 'type' => 'structure', 'required' => [ 'membershipIdentifier', ], 'members' => [ 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], 'status' => [ 'shape' => 'ProtectedQueryStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListProtectedQueriesOutput' => [ 'type' => 'structure', 'required' => [ 'protectedQueries', ], 'members' => [ 'nextToken' => [ 'shape' => 'PaginationToken', ], 'protectedQueries' => [ 'shape' => 'ProtectedQuerySummaryList', ], ], ], 'ListSchemasInput' => [ 'type' => 'structure', 'required' => [ 'collaborationIdentifier', ], 'members' => [ 'collaborationIdentifier' => [ 'shape' => 'CollaborationIdentifier', 'location' => 'uri', 'locationName' => 'collaborationIdentifier', ], 'schemaType' => [ 'shape' => 'SchemaType', 'location' => 'querystring', 'locationName' => 'schemaType', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListSchemasOutput' => [ 'type' => 'structure', 'required' => [ 'schemaSummaries', ], 'members' => [ 'schemaSummaries' => [ 'shape' => 'SchemaSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListTagsForResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'CleanroomsArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceOutput' => [ 'type' => 'structure', 'required' => [ 'tags', ], 'members' => [ 'tags' => [ 'shape' => 'TagMap', ], ], ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'MemberAbilities' => [ 'type' => 'list', 'member' => [ 'shape' => 'MemberAbility', ], ], 'MemberAbility' => [ 'type' => 'string', 'enum' => [ 'CAN_QUERY', 'CAN_RECEIVE_RESULTS', ], ], 'MemberList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MemberSpecification', ], 'max' => 9, 'min' => 0, ], 'MemberSpecification' => [ 'type' => 'structure', 'required' => [ 'accountId', 'memberAbilities', 'displayName', ], 'members' => [ 'accountId' => [ 'shape' => 'AccountId', ], 'memberAbilities' => [ 'shape' => 'MemberAbilities', ], 'displayName' => [ 'shape' => 'DisplayName', ], ], ], 'MemberStatus' => [ 'type' => 'string', 'enum' => [ 'INVITED', 'ACTIVE', 'LEFT', 'REMOVED', ], ], 'MemberSummary' => [ 'type' => 'structure', 'required' => [ 'accountId', 'status', 'displayName', 'abilities', 'createTime', 'updateTime', ], 'members' => [ 'accountId' => [ 'shape' => 'AccountId', ], 'status' => [ 'shape' => 'MemberStatus', ], 'displayName' => [ 'shape' => 'DisplayName', ], 'abilities' => [ 'shape' => 'MemberAbilities', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'membershipId' => [ 'shape' => 'UUID', ], 'membershipArn' => [ 'shape' => 'MembershipArn', ], ], ], 'MemberSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MemberSummary', ], ], 'Membership' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'collaborationArn', 'collaborationId', 'collaborationCreatorAccountId', 'collaborationCreatorDisplayName', 'collaborationName', 'createTime', 'updateTime', 'status', 'memberAbilities', 'queryLogStatus', ], 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'arn' => [ 'shape' => 'MembershipArn', ], 'collaborationArn' => [ 'shape' => 'CollaborationArn', ], 'collaborationId' => [ 'shape' => 'UUID', ], 'collaborationCreatorAccountId' => [ 'shape' => 'AccountId', ], 'collaborationCreatorDisplayName' => [ 'shape' => 'DisplayName', ], 'collaborationName' => [ 'shape' => 'CollaborationName', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'status' => [ 'shape' => 'MembershipStatus', ], 'memberAbilities' => [ 'shape' => 'MemberAbilities', ], 'queryLogStatus' => [ 'shape' => 'MembershipQueryLogStatus', ], ], ], 'MembershipArn' => [ 'type' => 'string', 'max' => 100, 'min' => 0, 'pattern' => 'arn:aws:[\\w]+:[\\w]{2}-[\\w]{4,9}-[\\d]:[\\d]{12}:membership/[\\d\\w-]+', ], 'MembershipIdentifier' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '.*[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}.*', ], 'MembershipQueryLogStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'MembershipStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'REMOVED', 'COLLABORATION_DELETED', ], ], 'MembershipSummary' => [ 'type' => 'structure', 'required' => [ 'id', 'arn', 'collaborationArn', 'collaborationId', 'collaborationCreatorAccountId', 'collaborationCreatorDisplayName', 'collaborationName', 'createTime', 'updateTime', 'status', 'memberAbilities', ], 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'arn' => [ 'shape' => 'MembershipArn', ], 'collaborationArn' => [ 'shape' => 'CollaborationArn', ], 'collaborationId' => [ 'shape' => 'CollaborationIdentifier', ], 'collaborationCreatorAccountId' => [ 'shape' => 'AccountId', ], 'collaborationCreatorDisplayName' => [ 'shape' => 'DisplayName', ], 'collaborationName' => [ 'shape' => 'CollaborationName', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'status' => [ 'shape' => 'MembershipStatus', ], 'memberAbilities' => [ 'shape' => 'MemberAbilities', ], ], ], 'MembershipSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MembershipSummary', ], ], 'PaginationToken' => [ 'type' => 'string', 'max' => 10240, 'min' => 0, ], 'ProtectedQuery' => [ 'type' => 'structure', 'required' => [ 'id', 'membershipId', 'membershipArn', 'createTime', 'sqlParameters', 'status', 'resultConfiguration', ], 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'membershipId' => [ 'shape' => 'UUID', ], 'membershipArn' => [ 'shape' => 'MembershipArn', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'sqlParameters' => [ 'shape' => 'ProtectedQuerySQLParameters', ], 'status' => [ 'shape' => 'ProtectedQueryStatus', ], 'resultConfiguration' => [ 'shape' => 'ProtectedQueryResultConfiguration', ], 'statistics' => [ 'shape' => 'ProtectedQueryStatistics', ], 'result' => [ 'shape' => 'ProtectedQueryResult', ], 'error' => [ 'shape' => 'ProtectedQueryError', ], ], ], 'ProtectedQueryError' => [ 'type' => 'structure', 'required' => [ 'message', 'code', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'code' => [ 'shape' => 'String', ], ], ], 'ProtectedQueryIdentifier' => [ 'type' => 'string', 'max' => 36, 'min' => 1, 'pattern' => '.*[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}.*', ], 'ProtectedQueryOutput' => [ 'type' => 'structure', 'members' => [ 's3' => [ 'shape' => 'ProtectedQueryS3Output', ], ], 'union' => true, ], 'ProtectedQueryOutputConfiguration' => [ 'type' => 'structure', 'members' => [ 's3' => [ 'shape' => 'ProtectedQueryS3OutputConfiguration', ], ], 'union' => true, ], 'ProtectedQueryResult' => [ 'type' => 'structure', 'required' => [ 'output', ], 'members' => [ 'output' => [ 'shape' => 'ProtectedQueryOutput', ], ], ], 'ProtectedQueryResultConfiguration' => [ 'type' => 'structure', 'required' => [ 'outputConfiguration', ], 'members' => [ 'outputConfiguration' => [ 'shape' => 'ProtectedQueryOutputConfiguration', ], ], ], 'ProtectedQueryS3Output' => [ 'type' => 'structure', 'required' => [ 'location', ], 'members' => [ 'location' => [ 'shape' => 'String', ], ], ], 'ProtectedQueryS3OutputConfiguration' => [ 'type' => 'structure', 'required' => [ 'resultFormat', 'bucket', ], 'members' => [ 'resultFormat' => [ 'shape' => 'ResultFormat', ], 'bucket' => [ 'shape' => 'ProtectedQueryS3OutputConfigurationBucketString', ], 'keyPrefix' => [ 'shape' => 'KeyPrefix', ], ], ], 'ProtectedQueryS3OutputConfigurationBucketString' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'pattern' => '.*(?!^(\\d+\\.)+\\d+$)(^(([a-z0-9]|[a-z0-9][a-z0-9\\-]*[a-z0-9])\\.)*([a-z0-9]|[a-z0-9][a-z0-9\\-]*[a-z0-9])$).*', ], 'ProtectedQuerySQLParameters' => [ 'type' => 'structure', 'required' => [ 'queryString', ], 'members' => [ 'queryString' => [ 'shape' => 'ProtectedQuerySQLParametersQueryStringString', ], ], 'sensitive' => true, ], 'ProtectedQuerySQLParametersQueryStringString' => [ 'type' => 'string', 'max' => 15000, 'min' => 0, ], 'ProtectedQueryStatistics' => [ 'type' => 'structure', 'members' => [ 'totalDurationInMillis' => [ 'shape' => 'Long', ], ], ], 'ProtectedQueryStatus' => [ 'type' => 'string', 'enum' => [ 'SUBMITTED', 'STARTED', 'CANCELLED', 'CANCELLING', 'FAILED', 'SUCCESS', 'TIMED_OUT', ], ], 'ProtectedQuerySummary' => [ 'type' => 'structure', 'required' => [ 'id', 'membershipId', 'membershipArn', 'createTime', 'status', ], 'members' => [ 'id' => [ 'shape' => 'UUID', ], 'membershipId' => [ 'shape' => 'UUID', ], 'membershipArn' => [ 'shape' => 'MembershipArn', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'status' => [ 'shape' => 'ProtectedQueryStatus', ], ], ], 'ProtectedQuerySummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProtectedQuerySummary', ], ], 'ProtectedQueryType' => [ 'type' => 'string', 'enum' => [ 'SQL', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'required' => [ 'message', 'resourceId', 'resourceType', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'resourceId' => [ 'shape' => 'String', ], 'resourceType' => [ 'shape' => 'ResourceType', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResourceType' => [ 'type' => 'string', 'enum' => [ 'CONFIGURED_TABLE', 'COLLABORATION', 'MEMBERSHIP', 'CONFIGURED_TABLE_ASSOCIATION', ], ], 'ResultFormat' => [ 'type' => 'string', 'enum' => [ 'CSV', 'PARQUET', ], ], 'RoleArn' => [ 'type' => 'string', 'max' => 512, 'min' => 32, 'pattern' => 'arn:aws:iam::[\\w]+:role/[\\w+=,./@-]+', ], 'ScalarFunctions' => [ 'type' => 'string', 'enum' => [ 'TRUNC', 'ABS', 'CEILING', 'FLOOR', 'LN', 'LOG', 'ROUND', 'SQRT', 'CAST', 'LOWER', 'RTRIM', 'UPPER', 'COALESCE', ], ], 'ScalarFunctionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ScalarFunctions', ], ], 'Schema' => [ 'type' => 'structure', 'required' => [ 'columns', 'partitionKeys', 'analysisRuleTypes', 'creatorAccountId', 'name', 'collaborationId', 'collaborationArn', 'description', 'createTime', 'updateTime', 'type', ], 'members' => [ 'columns' => [ 'shape' => 'ColumnList', ], 'partitionKeys' => [ 'shape' => 'ColumnList', ], 'analysisRuleTypes' => [ 'shape' => 'AnalysisRuleTypeList', ], 'analysisMethod' => [ 'shape' => 'AnalysisMethod', ], 'creatorAccountId' => [ 'shape' => 'AccountId', ], 'name' => [ 'shape' => 'TableAlias', ], 'collaborationId' => [ 'shape' => 'UUID', ], 'collaborationArn' => [ 'shape' => 'CollaborationArn', ], 'description' => [ 'shape' => 'TableDescription', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'type' => [ 'shape' => 'SchemaType', ], ], ], 'SchemaList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Schema', ], 'max' => 25, 'min' => 0, ], 'SchemaSummary' => [ 'type' => 'structure', 'required' => [ 'name', 'type', 'creatorAccountId', 'createTime', 'updateTime', 'collaborationId', 'collaborationArn', 'analysisRuleTypes', ], 'members' => [ 'name' => [ 'shape' => 'TableAlias', ], 'type' => [ 'shape' => 'SchemaType', ], 'creatorAccountId' => [ 'shape' => 'AccountId', ], 'createTime' => [ 'shape' => 'Timestamp', ], 'updateTime' => [ 'shape' => 'Timestamp', ], 'collaborationId' => [ 'shape' => 'UUID', ], 'collaborationArn' => [ 'shape' => 'CollaborationArn', ], 'analysisRuleTypes' => [ 'shape' => 'AnalysisRuleTypeList', ], 'analysisMethod' => [ 'shape' => 'AnalysisMethod', ], ], ], 'SchemaSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SchemaSummary', ], ], 'SchemaType' => [ 'type' => 'string', 'enum' => [ 'TABLE', ], ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'required' => [ 'message', 'quotaName', 'quotaValue', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'quotaName' => [ 'shape' => 'String', ], 'quotaValue' => [ 'shape' => 'Double', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'StartProtectedQueryInput' => [ 'type' => 'structure', 'required' => [ 'type', 'membershipIdentifier', 'sqlParameters', 'resultConfiguration', ], 'members' => [ 'type' => [ 'shape' => 'ProtectedQueryType', ], 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], 'sqlParameters' => [ 'shape' => 'ProtectedQuerySQLParameters', ], 'resultConfiguration' => [ 'shape' => 'ProtectedQueryResultConfiguration', ], ], ], 'StartProtectedQueryOutput' => [ 'type' => 'structure', 'required' => [ 'protectedQuery', ], 'members' => [ 'protectedQuery' => [ 'shape' => 'ProtectedQuery', ], ], ], 'String' => [ 'type' => 'string', ], 'TableAlias' => [ 'type' => 'string', 'max' => 128, 'min' => 0, 'pattern' => '[a-zA-Z0-9_](([a-zA-Z0-9_ ]+-)*([a-zA-Z0-9_ ]+))?', ], 'TableAliasList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TableAlias', ], 'max' => 25, 'min' => 1, ], 'TableDescription' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'pattern' => '[\\u0020-\\uD7FF\\uE000-\\uFFFD\\uD800\\uDBFF-\\uDC00\\uDFFF\\t\\r\\n]*', ], 'TableReference' => [ 'type' => 'structure', 'members' => [ 'glue' => [ 'shape' => 'GlueTableReference', ], ], 'union' => true, ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '(?!aws:).{1,128}', ], 'TagKeys' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], ], 'TagMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 200, 'min' => 0, ], 'TagResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'CleanroomsArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'TagResourceOutput' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'TargetProtectedQueryStatus' => [ 'type' => 'string', 'enum' => [ 'CANCELLED', ], ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'Timestamp' => [ 'type' => 'timestamp', ], 'UUID' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '.*[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}.*', ], 'UntagResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'CleanroomsArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeys', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceOutput' => [ 'type' => 'structure', 'members' => [], ], 'UpdateCollaborationInput' => [ 'type' => 'structure', 'required' => [ 'collaborationIdentifier', ], 'members' => [ 'collaborationIdentifier' => [ 'shape' => 'CollaborationIdentifier', 'location' => 'uri', 'locationName' => 'collaborationIdentifier', ], 'name' => [ 'shape' => 'CollaborationName', ], 'description' => [ 'shape' => 'CollaborationDescription', ], ], ], 'UpdateCollaborationOutput' => [ 'type' => 'structure', 'required' => [ 'collaboration', ], 'members' => [ 'collaboration' => [ 'shape' => 'Collaboration', ], ], ], 'UpdateConfiguredTableAnalysisRuleInput' => [ 'type' => 'structure', 'required' => [ 'configuredTableIdentifier', 'analysisRuleType', 'analysisRulePolicy', ], 'members' => [ 'configuredTableIdentifier' => [ 'shape' => 'ConfiguredTableIdentifier', 'location' => 'uri', 'locationName' => 'configuredTableIdentifier', ], 'analysisRuleType' => [ 'shape' => 'ConfiguredTableAnalysisRuleType', 'location' => 'uri', 'locationName' => 'analysisRuleType', ], 'analysisRulePolicy' => [ 'shape' => 'ConfiguredTableAnalysisRulePolicy', ], ], ], 'UpdateConfiguredTableAnalysisRuleOutput' => [ 'type' => 'structure', 'required' => [ 'analysisRule', ], 'members' => [ 'analysisRule' => [ 'shape' => 'ConfiguredTableAnalysisRule', ], ], ], 'UpdateConfiguredTableAssociationInput' => [ 'type' => 'structure', 'required' => [ 'configuredTableAssociationIdentifier', 'membershipIdentifier', ], 'members' => [ 'configuredTableAssociationIdentifier' => [ 'shape' => 'ConfiguredTableAssociationIdentifier', 'location' => 'uri', 'locationName' => 'configuredTableAssociationIdentifier', ], 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], 'description' => [ 'shape' => 'TableDescription', ], 'roleArn' => [ 'shape' => 'RoleArn', ], ], ], 'UpdateConfiguredTableAssociationOutput' => [ 'type' => 'structure', 'required' => [ 'configuredTableAssociation', ], 'members' => [ 'configuredTableAssociation' => [ 'shape' => 'ConfiguredTableAssociation', ], ], ], 'UpdateConfiguredTableInput' => [ 'type' => 'structure', 'required' => [ 'configuredTableIdentifier', ], 'members' => [ 'configuredTableIdentifier' => [ 'shape' => 'ConfiguredTableIdentifier', 'location' => 'uri', 'locationName' => 'configuredTableIdentifier', ], 'name' => [ 'shape' => 'DisplayName', ], 'description' => [ 'shape' => 'TableDescription', ], ], ], 'UpdateConfiguredTableOutput' => [ 'type' => 'structure', 'required' => [ 'configuredTable', ], 'members' => [ 'configuredTable' => [ 'shape' => 'ConfiguredTable', ], ], ], 'UpdateMembershipInput' => [ 'type' => 'structure', 'required' => [ 'membershipIdentifier', ], 'members' => [ 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], 'queryLogStatus' => [ 'shape' => 'MembershipQueryLogStatus', ], ], ], 'UpdateMembershipOutput' => [ 'type' => 'structure', 'required' => [ 'membership', ], 'members' => [ 'membership' => [ 'shape' => 'Membership', ], ], ], 'UpdateProtectedQueryInput' => [ 'type' => 'structure', 'required' => [ 'membershipIdentifier', 'protectedQueryIdentifier', 'targetStatus', ], 'members' => [ 'membershipIdentifier' => [ 'shape' => 'MembershipIdentifier', 'location' => 'uri', 'locationName' => 'membershipIdentifier', ], 'protectedQueryIdentifier' => [ 'shape' => 'ProtectedQueryIdentifier', 'location' => 'uri', 'locationName' => 'protectedQueryIdentifier', ], 'targetStatus' => [ 'shape' => 'TargetProtectedQueryStatus', ], ], ], 'UpdateProtectedQueryOutput' => [ 'type' => 'structure', 'required' => [ 'protectedQuery', ], 'members' => [ 'protectedQuery' => [ 'shape' => 'ProtectedQuery', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], 'reason' => [ 'shape' => 'ValidationExceptionReason', ], 'fieldList' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'name', 'message', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'ValidationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'FIELD_VALIDATION_FAILED', 'INVALID_CONFIGURATION', 'INVALID_QUERY', ], ], ],];
